<?php
header('Content-Type: text/html');


include('session.php');
include('config.php');


// Get selected year (default to current year)
$selectedYear = isset($_GET['year']) ? (int)$_GET['year'] : date("Y");

// Sample pumps and barangays
$pumps = [
    1 => ["Abas", "Abucay", "Banuyo (Pob)", "Bayasong"],
    2 => ["Binanuahan (Pob)", "Calongay", "Dao (Pob)", "Esperanza"],
    3 => ["Guiron", "Mabanate", "Marifosque", "Mercedes"],
    4 => ["Putiao", "San Antonio (Sapa)", "San Jose", "San Fe"]
];

$barangays = [];
$priorities = [];
$pumpNumbers = [];
$totalConsumption = [];

// Generate random data based on the selected year
foreach ($pumps as $pumpNumber => $areas) {
    foreach ($areas as $barangay) {
        $barangays[] = $barangay;
        $priorities[] = rand(50, 100); // Random prioritization percentage
        $pumpNumbers[] = "Pump #" . $pumpNumber;
        $totalConsumption[] = rand(1000, 5000); // Random total water consumption in cubic meters
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Water Supply Prioritization System</title>

    
        <link rel="stylesheet" href="assets/css/bootstrap.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script> <!-- For AJAX -->
        <link rel="icon" type="image/png" href="images/logo_2.png"/>
    <link href="assets/css/bootstrap.css" rel="stylesheet" />
    <link href="assets/css/font-awesome.css" rel="stylesheet" />
    <link href="assets/js/morris/morris-0.4.3.min.css" rel="stylesheet" />
    <link href="assets/css/custom.css" rel="stylesheet" />
    <link href='http://fonts.googleapis.com/css?family=Open+Sans' rel='stylesheet' type='text/css' />
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
</head>
<body>
            <div id="wrapper">
        <!-- NAVBAR and LOGOUT Button -->
        <nav class="navbar navbar-default navbar-cls-top " role="navigation" style="margin-bottom: 0">
            <div class="navbar-header">
                <a class="navbar-brand" href="admin.php" style="background-color: orange;">ADMIN</a> 
            </div>
            <div style="color: white; padding: 15px 50px 5px 50px; float: right; font-size: 16px;"> 
                <?php echo $_SESSION['login_user']; ?> &nbsp; 
                <a id="myBtn" class="btn btn-danger square-btn-adjust">Logout</a>
            </div>
        </nav>

        <!-- SIDEBAR -->
           <!-- /. NAV TOP  -->
           <nav class="navbar-default navbar-side" role="navigation" style="height: 150%;">
            <div class="sidebar-collapse">
                <ul class="nav" id="main-menu">
				<li class="text-center">
                    <img src="images/logo_1.jpg" class=" img-responsive" style="border-radius: 50%; width: 230px; padding: 20px;"/>
					</li>
				
					
                    <li>
                        <a  href="admin.php" ><i class="fa fa-dashboard fa-3x" ></i> Dashboard</a>
                    </li>
                    <li>
                        <a href="data_analytics.php" style="height: 80px; padding-top:35px;"><img src="images/monitoring.png" width="71px" height="50px" style="margin-left: -18px; margin-top: -18px; float: left;"/><i class="fa fa-3x"></i> <span style="margin-left: -10px;">Data Analytics</span></a>
                    </li>
                    <li><a class="" href="bill_list.php" style="height: 80px; padding-top:35px;"><img src="images/bill.png" width="60px" height="63px" style="margin-left: -10px; margin-top: -20px; float: left;"/><i class="fa fa-3x"></i> Bill Management</a></li>
                    <li><a class="" href="demand_forecasting.php" style="height: 80px; padding-top:35px;"><img src="images/forecasting_icon.png" width="80px" height="58px" style="margin-left: -20px; margin-top: -20px; float: left;"/><i class="fa fa-3x"></i> Demand Forecasting</a></li>                         
                    <li><a class="active-menu" href="prioritization.php" style="height: 80px; padding-top:35px;"><img src="images/a.png" width="60px" height="58px" style="margin-left: -10px; margin-top: -20px; float: left; border-radius: 50%;"/><i class="fa fa-3x"></i>Prioritization</a></li>                         
                    <!-- <li>-->
                    <!--    <a  href="messages.php" style="height: 80px; padding-top:35px;"><img src="images/message_white.jpg" width="50px" height="50px" style="margin-left: -5px; margin-top: -17px; float: left;"><i class="fa fa-3x"></i> Messages</a>-->
                    <!--</li>-->
                    <li>
                        <a  href="complaints.php" style="height: 80px; padding-top:35px;"><img src="images/task_gray.png" width="61px" height="50px" style="margin-left: -11px; margin-top: -18px; float: left;"/><i class="fa fa-3x"></i> Complaints</a>
                    </li>
                    <li>
                        <a href="announcements-admin.php" style="height: 80px; padding-top:35px;"><img src="images/announcement.png" width="61px" height="50px" style="margin-left: -11px; margin-top: -18px; float: left;"/> &nbsp &nbspAnnouncements</a>
                    </li> 
                    <!-- <li>
                        <a  href="tasks.php" style="height: 80px; padding-top:35px;"><img src="images/task_gray.png" width="61px" height="50px" style="margin-left: -11px; margin-top: -18px; float: left;"/><i class="fa fa-3x"></i> Tasks</a>
                    </li>
                    <li>
                        <a  href="notifications.php" style="height: 80px; padding-top:35px;"><img src="images/notification_white.png" width="50px" height="50px" style="margin-left: -9px; margin-top: -18px; float: left;"/><i class="fa fa-3x"></i> Notifications</a>
                    </li>  
                    <li>
                        <a  href="assignments.php" style="height: 80px; padding-top:35px;"><img src="images/requirement_white.png" width="50px" height="50px" style="margin-left: -9px; margin-top: -15px; float: left;"/><i class="fa fa-3x"></i> Requirements</a>
                    </li>   -->
                    <li>
                        <a  href="accounts.php" style="height: 80px; padding-top:35px;"><img src="images/accounts_white1.png" width="60px" height="63px" style="margin-left: -10px; margin-top: -20px; float: left;"/><i class="fa fa-3x"></i> Accounts</a>
                    </li>     
                    <li>
                        <a href="vmc-su.php"><i class="fa fa-sitemap fa-3x"></i> &nbsp VMC</a>
                    </li>       
                    <!-- <li>
                        <a href="register-faculty.php" style="height: 80px; padding-top:35px;"><img src="images/accounts_white1.png" width="60px" height="63px" style="margin-left: -10px; margin-top: -20px; float: left;"/><i class="fa fa-3x"></i> Registration</a>
                    </li>   -->
                      <!-- <li>
                        <a  href="evaluations.php" style="height: 80px; padding-top:35px;"><img src="images/comments_white.png" width="50px" height="56px" style="margin-left: -5px; margin-top: -18px; float: left;"/><i class="fa fa-3x"></i> Evaluations</a>
                    </li> -->
                     <!-- <li>
                        <a href="register.php" style="height: 80px; padding-top:35px;"><img src="images/register_user.png" width="50px" height="56px" style="margin-left: -5px; margin-top: -18px; float: left;"/><i class="fa fa-3x"></i> Register Member</a>
                    </li> -->
                </ul>
            </div>
        </nav>

<div id="page-wrapper">
    <div id="page-inner">
    <div class="">
        <h2 class="text-center">Water Supply Prioritization System</h2>

        <!-- Year Selection Dropdown -->
        <div class="text-center mb-4">
            <label for="yearSelect">Select Year:</label>
            <select id="yearSelect" class="form-select w-auto d-inline-block">
                <?php
                $currentYear = date("Y");
                for ($year = $currentYear; $year <= $currentYear + 5; $year++) {
                    echo "<option value='$year'" . ($year == $selectedYear ? " selected" : "") . ">$year</option>";
                }
                ?>
            </select>
        </div>

        <canvas id="priorityChart"></canvas>
    </div>
<div>
    </div>
</div>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const data = {
                barangays: <?php echo json_encode($barangays); ?>,
                priorities: <?php echo json_encode($priorities); ?>,
                pumpNumbers: <?php echo json_encode($pumpNumbers); ?>,
                totalConsumption: <?php echo json_encode($totalConsumption); ?>
            };
            renderChart(data);

            // Event listener for year selection change
            document.getElementById("yearSelect").addEventListener("change", function () {
                const selectedYear = this.value;
                window.location.href = "?year=" + selectedYear;
            });
        });

        function renderChart(data) {
            const ctx = document.getElementById('priorityChart').getContext('2d');
            new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: data.barangays,
                    datasets: [
                        {
                            label: 'Prioritization (%)',
                            data: data.priorities,
                            backgroundColor: 'rgba(75, 192, 192, 0.7)',
                            borderColor: 'rgba(75, 192, 192, 1)',
                            borderWidth: 2,
                            yAxisID: 'y'
                        },
                        {
                            label: 'Total Consumption (m³)',
                            data: data.totalConsumption,
                            backgroundColor: 'rgba(255, 99, 132, 0.7)',
                            borderColor: 'rgba(255, 99, 132, 1)',
                            borderWidth: 2,
                            type: 'line',
                            yAxisID: 'y1'
                        }
                    ]
                },
                options: {
                    responsive: true,
                    interaction: {
                        mode: 'index',
                        intersect: false
                    },
                    plugins: {
                        tooltip: {
                            callbacks: {
                                afterBody: function (tooltipItems) {
                                    const index = tooltipItems[0].dataIndex;
                                    return [
                                        'Source: ' + data.pumpNumbers[index],
                                        'Total Consumption: ' + data.totalConsumption[index] + ' m³'
                                    ];
                                }
                            }
                        },
                        legend: {
                            position: 'top'
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            position: 'left',
                            title: {
                                display: true,
                                text: 'Prioritization (%)'
                            }
                        },
                        y1: {
                            beginAtZero: true,
                            position: 'right',
                            grid: {
                                drawOnChartArea: false
                            },
                            title: {
                                display: true,
                                text: 'Total Consumption (m³)'
                            }
                        }
                    }
                }
            });
        }
    </script>

</body>
</html>
