<?php 
include('config.php');

// Get the selected year from the AJAX request
$selected_year = isset($_GET['year']) ? $_GET['year'] : date('Y');

// Sample barangays assigned to pumps
$pumps = [
    1 => ['Abas', 'Abucay', 'Banuyo (Pob)', 'Bayasong'],
    2 => ['Binanuahan (Pob)', 'Calongay', 'Dao (Pob)', 'Esperanza'],
    3 => ['Guiron', 'Mabanate', 'Marifosque', 'Mercedes'],
    4 => ['Putiao', 'San Antonio (Sapa)', 'San Jose', 'San Fe']
];

// Generate new data based on the selected year
$supply_data = [];
foreach ($pumps as $pump => $barangays) {
    $total_supply = rand(5000, 10000); // Random total water supply per pump (m³)
    $monthly_demand = rand(1000, 2500); // Random monthly demand per pump (m³)
    $months_supply = floor($total_supply / $monthly_demand); // Calculate months of supply
    
    $supply_data[] = [
        'pump' => $pump,
        'year' => $selected_year,
        'barangays' => implode(', ', $barangays),
        'total_supply' => $total_supply,
        'monthly_demand' => $monthly_demand,
        'months_supply' => $months_supply
    ];
}

// Convert PHP array to JSON and send it back to AJAX
echo json_encode($supply_data);
?>
