<?php
// Include database connection
include('config.php');

// Set headers for file download
header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="barangay_demand_data.csv"');

// Open output stream
$output = fopen('php://output', 'w');

// Write column headers to CSV
fputcsv($output, ['Barangay Name', 'Total Households', 'Water Demand (Cubic Meters)']);

// Fetch data from the database
$query = "SELECT barangay_name, total_households FROM barangay_tb";
$result = mysqli_query($db, $query);

while ($row = mysqli_fetch_assoc($result)) {
    // Calculate water demand based on households (modify calculation if necessary)
    $water_demand = $row['total_households'] * 7;
    fputcsv($output, [$row['barangay_name'], $row['total_households'], $water_demand]);
}

// Close output stream
fclose($output);
exit;
?>
