<?php 
include('session.php');
include('config.php');
?>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>ADMIN</title>
    <link rel="icon" type="image/png" href="images/logo_2.png"/>
    <link href="assets/css/bootstrap.css" rel="stylesheet" />
    <link href="assets/css/font-awesome.css" rel="stylesheet" />
    <link href="assets/js/morris/morris-0.4.3.min.css" rel="stylesheet" />
    <link href="assets/css/custom.css" rel="stylesheet" />
    <link href='http://fonts.googleapis.com/css?family=Open+Sans' rel='stylesheet' type='text/css' />
    <link rel="stylesheet" href="css/css/spinners.css" type="text/css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <style>
/* The Modal (background) */
.modal {
  display: none; /* Hidden by default */
  position: fixed; /* Stay in place */
  z-index: 10000000; /* Sit on top */
  padding-top: 100px; /* Location of the box */
  left: 0;
  top: 0;
  width: 100%; /* Full width */
  height: 100%; /* Full height */
  overflow: auto; /* Enable scroll if needed */
  background-color: rgb(0,0,0); /* Fallback color */
  background-color: rgba(0,0,0,0.4); /* Black w/ opacity */
}

/* Modal Content */
.modal-content {
  background-color: #fefefe;
  margin: auto;
  padding: 20px;
  border: 1px solid #888;
  width: 80%;
}

/* The Close Button */
.close {
  color: #aaaaaa;
  float: right;
  font-size: 28px;
  font-weight: bold;
}

.close:hover,
.close:focus {
  color: #000;
  text-decoration: none;
  cursor: pointer;
}
</style>

<style>
    .percentage-red {
        color: red;
        font-weight: bold;
    }
    .percentage-orange {
        color: orange;
        font-weight: bold;
    }
    .percentage-green {
        color: green;
        font-weight: bold;
    }
</style>


</head>
<body>
    
    
<div id="wrapper">
        <nav class="navbar navbar-default navbar-cls-top " role="navigation" style="margin-bottom: 0">
            <div class="navbar-header">
                <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".sidebar-collapse" >
                    <span class="sr-only">Toggle navigation</span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>
                <a class="navbar-brand" href="admin.php" style="background-color: orange;">ADMIN</a> 
            </div>
  <div style="color: white;
padding: 15px 50px 5px 50px;
float: right;
font-size: 16px;"> 


        <!-- LOGOUT -->
        <?php echo $_SESSION['login_user']; ?> &nbsp; <a id="myBtn" class="btn btn-danger square-btn-adjust">Logout</a> </div>
        
        <!-- The Modal -->
        <div id="myModal" class="modal">

        <!-- Modal content -->
        <div class="modal-content" style="border-radius: 20px; height: 235px; width: 300px;">
        <span class="close">&times;</span>
        <h3>Logout</h3>
        <h4>Are you sure you want to logout?</h4>
        <br><br><br>
        <a onclick="document.getElementById('myModal').style.display='none'" class="logout" style="cursor: pointer; width: 100px; float:right; width: 70px; padding: 10px; color:white; margin-top:-20px; text-align: center; background-color: gray; border-radius: 5px; width: 100px;">No</a>
        <a href="logout.php" id="myBtn" class="logout"  style="cursor: pointer; width: 70px; padding: 10px; color:white; text-align: center; float:right; margin-top:-20px; margin-right: 5px; background-color: #4c9be1; border-radius: 5px; width: 100px;">Yes</a>

        </div>
        </div>
        </nav>   
           <!-- /. NAV TOP  -->
                <nav class="navbar-default navbar-side" role="navigation" style="height: 230%;">
            <div class="sidebar-collapse">
                <ul class="nav" id="main-menu">
				<li class="text-center">
                    <img src="images/logo_1.jpg" class=" img-responsive" style="border-radius: 50%; width: 230px; padding: 20px;"/>
					</li>
				
					
                    <li>
                        <a  href="admin.php" ><i class="fa fa-dashboard fa-3x" ></i> Dashboard</a>
                    </li>
                    <li>
                        <a class="active-menu" href="data_analytics.php" style="height: 80px; padding-top:35px;"><img src="images/monitoring.png" width="71px" height="50px" style="margin-left: -18px; margin-top: -18px; float: left;"/><i class="fa fa-3x"></i> <span style="margin-left: -10px;">Data Analytics</span></a>
                    </li>
                    <li><a class="" href="bill_list.php" style="height: 80px; padding-top:35px;"><img src="images/bill.png" width="60px" height="63px" style="margin-left: -10px; margin-top: -20px; float: left;"/><i class="fa fa-3x"></i> Bill Management</a></li>     
                    <li><a class="" href="demand_forecasting.php" style="height: 80px; padding-top:35px;"><img src="images/forecasting_icon.png" width="80px" height="58px" style="margin-left: -20px; margin-top: -20px; float: left;"/><i class="fa fa-3x"></i> Demand Forecasting</a></li>  
                    <li><a class="" href="prioritization.php" style="height: 80px; padding-top:35px;"><img src="images/a.png" width="60px" height="58px" style="margin-left: -10px; margin-top: -20px; float: left; border-radius: 50%;"/><i class="fa fa-3x"></i>Prioritization</a></li>  
                    <!-- <li>-->
                    <!--    <a  href="messages.php" style="height: 80px; padding-top:35px;"><img src="images/message_white.jpg" width="50px" height="50px" style="margin-left: -5px; margin-top: -17px; float: left;"><i class="fa fa-3x"></i> Messages</a>-->
                    <!--</li>-->
                    <li>
                        <a  href="complaints.php" style="height: 80px; padding-top:35px;"><img src="images/task_gray.png" width="61px" height="50px" style="margin-left: -11px; margin-top: -18px; float: left;"/><i class="fa fa-3x"></i> Complaints</a>
                    </li>
                    <li>
                        <a href="announcements-admin.php" style="height: 80px; padding-top:35px;"><img src="images/announcement.png" width="61px" height="50px" style="margin-left: -11px; margin-top: -18px; float: left;"/> &nbsp &nbspAnnouncements</a>
                    </li> 
                    <!--<li>
                        <a  href="notifications.php" style="height: 80px; padding-top:35px;"><img src="images/notification_white.png" width="50px" height="50px" style="margin-left: -9px; margin-top: -18px; float: left;"/><i class="fa fa-3x"></i> Notifications</a>
                    </li>  
                    <li>
                        <a  href="assignments.php" style="height: 80px; padding-top:35px;"><img src="images/requirement_white.png" width="50px" height="50px" style="margin-left: -9px; margin-top: -15px; float: left;"/><i class="fa fa-3x"></i> Requirements</a>
                    </li>   -->
                    <li>
                        <a  href="accounts.php" style="height: 80px; padding-top:35px;"><img src="images/accounts_white1.png" width="60px" height="63px" style="margin-left: -10px; margin-top: -20px; float: left;"/><i class="fa fa-3x"></i> Accounts</a>
                    </li>     
                    <li>
                        <a href="vmc-su.php"><i class="fa fa-sitemap fa-3x"></i> &nbsp VMC</a>
                    </li>       
                    <!-- <li>
                        <a href="register-faculty.php" style="height: 80px; padding-top:35px;"><img src="images/accounts_white1.png" width="60px" height="63px" style="margin-left: -10px; margin-top: -20px; float: left;"/><i class="fa fa-3x"></i> Registration</a>
                    </li>   -->
                      <!-- <li>
                        <a  href="evaluations.php" style="height: 80px; padding-top:35px;"><img src="images/comments_white.png" width="50px" height="56px" style="margin-left: -5px; margin-top: -18px; float: left;"/><i class="fa fa-3x"></i> Evaluations</a>
                    </li> -->
                     <!-- <li>
                        <a href="register.php" style="height: 80px; padding-top:35px;"><img src="images/register_user.png" width="50px" height="56px" style="margin-left: -5px; margin-top: -18px; float: left;"/><i class="fa fa-3x"></i> Register Member</a>
                    </li> -->
                </ul>
               
            </div>
            
        </nav>  
        <!-- /. NAV SIDE  -->
    <div id="page-wrapper" style="min-height: 30px;">
        <div id="page-inner" style="min-height: 30px; height: 600px;">
            <h2 style="color: white; background-color: gray; padding: 18px; margin-top: -0.1px; font-family: Arial; font-weight: bold; font-size: 27px;">&nbsp DASHBOARD</h2>
            <hr />

            <!-- Analytics Section -->
            <h2 style="color: black;">Population and Billed Connections Analytics</h2>
            <span style="font-size: 18px; font-weight: bold;" for="yearSelect">Select Year:</span>
                <select id="yearSelect" onchange="generateRandomBilledConnections()" style="padding: 5px;">
                    <option value="2019">2019</option>
                    <option value="2020">2020</option>
                    <option value="2021">2021</option>
                    <option value="2022" selected>2022</option>
                    <option value="2023">2023</option>
                    <option value="2024">2024</option>
                </select>


            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Barangay</th>
                        <th>Total Households</th>
                        <th>Total Population</th>
                        <th>Total Billed Connections</th>
                        <th>Percentage Billed (Households)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    // Data for Population and Households (PSA 2020)
                    $population_data = [
                        ['Barangay' => 'Abas', 'Households' => 271, 'Population' => 1162],
                        ['Barangay' => 'Abucay', 'Households' => 604, 'Population' => 2820],
                        ['Barangay' => 'Banuyo (Pob)', 'Households' => 782, 'Population' => 3809],
                        ['Barangay' => 'Bayasong', 'Households' => 399, 'Population' => 1734],
                        ['Barangay' => 'Binanuahan (Pob)', 'Households' => 409, 'Population' => 1889],
                        ['Barangay' => 'Calongay', 'Households' => 403, 'Population' => 1920],
                        ['Barangay' => 'Dao (Pob)', 'Households' => 535, 'Population' => 2485],
                        ['Barangay' => 'Esperanza', 'Households' => 389, 'Population' => 1687],
                        ['Barangay' => 'Guiron', 'Households' => 197, 'Population' => 829],
                        ['Barangay' => 'Mabanate', 'Households' => 404, 'Population' => 1771],
                        ['Barangay' => 'Marifosque (Pob)', 'Households' => 537, 'Population' => 2473],
                        ['Barangay' => 'Mercedes', 'Households' => 221, 'Population' => 1035],
                        ['Barangay' => 'Putiao', 'Households' => 498, 'Population' => 2237],
                        ['Barangay' => 'San Antonio (Sapa)', 'Households' => 634, 'Population' => 2731],
                        ['Barangay' => 'San Jose', 'Households' => 271, 'Population' => 1233],
                        ['Barangay' => 'Santa Fe', 'Households' => 504, 'Population' => 2389]
                    ];

                    // Data for Billed Connections (as of December 31, 2022)
                    $billed_data = [
                        ['Barangay' => 'Abas', 'Billed' => 99],
                        ['Barangay' => 'Abucay', 'Billed' => 85],
                        ['Barangay' => 'Banuyo (Pob)', 'Billed' => 472],
                        ['Barangay' => 'Bayasong', 'Billed' => 114],
                        ['Barangay' => 'Binanuahan (Pob)', 'Billed' => 202],
                        ['Barangay' => 'Calongay', 'Billed' => 203],
                        ['Barangay' => 'Dao (Pob)', 'Billed' => 327],
                        ['Barangay' => 'Esperanza', 'Billed' => 60],
                        ['Barangay' => 'Guiron', 'Billed' => 54],
                        ['Barangay' => 'Mabanate', 'Billed' => 112],
                        ['Barangay' => 'Marifosque (Pob)', 'Billed' => 349],
                        ['Barangay' => 'Mercedes', 'Billed' => 12],
                        ['Barangay' => 'Putiao', 'Billed' => 107],
                        ['Barangay' => 'San Antonio (Sapa)', 'Billed' => 95],
                        ['Barangay' => 'San Jose', 'Billed' => 70],
                        ['Barangay' => 'Santa Fe', 'Billed' => 122]
                    ];

                    // Function to find the total billed connections per barangay
                    function get_total_billed($barangay) {
                        global $billed_data;
                        $total_billed = 0;
                        foreach ($billed_data as $data) {
                            if (strpos($data['Barangay'], $barangay) !== false) {
                                $total_billed += $data['Billed'];
                            }
                        }
                        return $total_billed;
                    }

                    // Loop through each barangay and display data
                    foreach ($population_data as $barangay_data) {
                        $barangay = $barangay_data['Barangay'];
                        $households = $barangay_data['Households'];
                        $population = $barangay_data['Population'];
                        $total_billed = get_total_billed($barangay);
                        $percentage_billed = ($total_billed / $households) * 100;
                    
                        // Determine color class based on percentage
                        if ($percentage_billed == 0) {
                            $color_class = "percentage-red";
                        } elseif ($percentage_billed > 0 && $percentage_billed < 40) {
                            $color_class = "percentage-orange";
                        } else {
                            $color_class = "percentage-green";
                        }
                    
                        echo "<tr>
                                <td>{$barangay}</td>
                                <td>{$households}</td>
                                <td>{$population}</td>
                                <td>{$total_billed}</td>
                                <td class='{$color_class}'>" . round($percentage_billed, 2) . "%</td>
                              </tr>";

                                  // Push data to arrays
                                    $barangay_labels[] = $barangay;
                                    $percentage_billed_data[] = round($percentage_billed, 2);
                                }

                                // Convert PHP arrays to JavaScript
                                $barangay_labels_json = json_encode($barangay_labels);
                                $percentage_billed_data_json = json_encode($percentage_billed_data);

                    
                    ?>
                    
                </tbody>
            </table>
        </div><br><br><br><br><br><br><br><br><br><br><br>
        <canvas id="billedChart" width="400" height="200"></canvas>
    </div>
</div>

<script>
    document.addEventListener("DOMContentLoaded", function() {
    generateRandomBilledConnections();
});

</script>

<script>
    function generateRandomBilledConnections() {
    // Iterate through the table rows and update the Total Billed Connections and Percentage Billed columns
    const table = document.querySelector("table tbody");
    const rows = table.getElementsByTagName("tr");

    for (let i = 0; i < rows.length; i++) {
        const row = rows[i];
        const households = parseInt(row.cells[1].textContent); // Total Households
        const totalBilledConnections = Math.floor(Math.random() * households); // Random total billed between 0 and total households
        const percentageBilled = ((totalBilledConnections / households) * 100).toFixed(2); // Calculate percentage

        // Update Total Billed Connections and Percentage Billed columns
        row.cells[3].textContent = totalBilledConnections;
        row.cells[4].textContent = percentageBilled + "%";

        // Set the color class based on the percentage
        let colorClass = "percentage-green";
        if (percentageBilled == 0) {
            colorClass = "percentage-red";
        } else if (percentageBilled > 0 && percentageBilled < 40) {
            colorClass = "percentage-orange";
        }

        // Update the class for the percentage column
        row.cells[4].className = colorClass;
    }

    updateChart();
}

</script>

<script>
function updateChart() {
    // Get updated data for the chart (percentages instead of total billed)
    let updatedPercentageData = [];
    document.querySelectorAll('td:nth-child(5)').forEach(function (cell) {
        // Remove the percentage sign and parse to float
        updatedPercentageData.push(parseFloat(cell.textContent));
    });

    // Update chart data with percentage billed data
    chart.data.datasets[0].data = updatedPercentageData;
    chart.update();
}
</script>



<script>
var ctx = document.getElementById('billedChart').getContext('2d');

// Get the data from PHP
var barangayLabels = <?php echo $barangay_labels_json; ?>;
var percentageBilledData = <?php echo $percentage_billed_data_json; ?>;

var chart = new Chart(ctx, {
    type: 'bar',
    data: {
        labels: barangayLabels,
        datasets: [{
            data: percentageBilledData,
            backgroundColor: function(context) {
                var value = context.raw;
                if (value === 0) {
                    return 'red';
                } else if (value > 0 && value < 40) {
                    return 'orange';
                } else {
                    return 'green';
                }
            },
            borderColor: '#777',
            borderWidth: 1
        }]
    },
    options: {
        plugins: {
            legend: {
                display: false // Disable the legend
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                max: 100
            }
        }
    }
});
</script>



    <!-- SCRIPTS -AT THE BOTOM TO REDUCE THE LOAD TIME-->
    <script src="//code.jquery.com/jquery-1.9.1.js"></script>
  <script src="//cdnjs.cloudflare.com/ajax/libs/Chart.js/2.4.0/Chart.min.js"></script>
<script type="text/javascript">
      var ctx = document.getElementById("chartjs_bar").getContext('2d');
                var myChart = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels:<?php echo json_encode($dept_off); ?>,
                        datasets: [{
                            backgroundColor: [
                               "#5969ff",
                                "#ff407b",
                                "#25d5f2",
                                "#ffc750",
                                "#2ec551",
                                "#7040fa",
                                "#ff004e"
                            ],
                            data:<?php echo json_encode($area); ?>,
                        }]
                    },
                    options: {
                           legend: {
                        display: false,
                        position: 'bottom',
 
                        labels: {
                            fontColor: '#71748d',
                            fontFamily: 'Circular Std Book',
                            fontSize: 14,
                        }
                    },
 
 
                }
                });
    </script>
    <!-- JQUERY SCRIPTS -->
    <script src="assets/js/jquery-1.10.2.js"></script>
      <!-- BOOTSTRAP SCRIPTS -->
    <script src="assets/js/bootstrap.min.js"></script>
    <!-- METISMENU SCRIPTS -->
    <script src="assets/js/jquery.metisMenu.js"></script>
     <!-- MORRIS CHART SCRIPTS -->
     <script src="assets/js/morris/raphael-2.1.0.min.js"></script>
    <script src="assets/js/morris/morris.js"></script>
      <!-- CUSTOM SCRIPTS -->
    <script src="assets/js/custom.js"></script>
    
        <script>
    // Get the modal
    var modal = document.getElementById("myModal");

    // Get the button that opens the modal
    var btn = document.getElementById("myBtn");

    // Get the <span> element that closes the modal
    var span = document.getElementsByClassName("close")[0];

    // When the user clicks the button, open the modal 
    btn.onclick = function() {
    modal.style.display = "block";
    }

    // When the user clicks on <span> (x), close the modal
    span.onclick = function() {
    modal.style.display = "none";
    }

    // When the user clicks anywhere outside of the modal, close it
    window.onclick = function(event) {
    if (event.target == modal) {
        modal.style.display = "none";
    }
    }
    </script>

<!-- SCRIPTS -->
<script src="assets/js/jquery-1.10.2.js"></script>
<script src="assets/js/bootstrap.min.js"></script>
<script src="assets/js/jquery.metisMenu.js"></script>
<script src="assets/js/custom.js"></script>

</body>
</html>
