
<?php
// Check existence of id parameter before processing further
if(isset($_GET["ID"]) && !empty(trim($_GET["ID"]))){
    // Include config file
    require_once "config.php";
    
    // Prepare a select statement
    $sql = "SELECT * FROM members WHERE ID = ?";
    
    if($stmt = $db->prepare($sql)){
        // Bind variables to the prepared statement as parameters
        $stmt->bind_param("i", $param_id);
        
        // Set parameters
        $param_id = trim($_GET["ID"]);
        
        // Attempt to execute the prepared statement
        if($stmt->execute()){
            $result = $stmt->get_result();
            
            if($result->num_rows == 1){
                /* Fetch result row as an associative array. Since the result set
                contains only one row, we don't need to use while loop */
                $row = $result->fetch_array(MYSQLI_ASSOC);
                
                // Retrieve individual field value
                $Last_Name = $row["Last_Name"];
                $First_Name = $row["First_Name"];
                $Middle_Initial = $row["Middle_Initial"];
                $Birthdate = $row["Birthdate"];
                $Gender = $row["Gender"];
                $Address = $row["Address"];
                $Contact_Number = $row["Contact_Number"];
                $Email = $row["Email"];
                $Password = $row["Password"];
                $Usertype = $row["Usertype"];

                $decrypted_pass = md5($Password);
            } else{
                // URL doesn't contain valid id parameter. Redirect to error page
                echo "Error: " . $sql . "<br>" . mysqli_error($db);
                exit();
            }
            
        } else{
            echo "Oops! Something went wrong. Please try again later.";
        }
    }
     
    // Close statement
    $stmt->close();
    
    // Close connection
    $db->close();
} else{
    // URL doesn't contain id parameter. Redirect to error page
    header("location: error.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>View Record</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        .wrapper{
            width: 600px;
            margin: 0 auto;
        }
    </style>
<!--===============================================================================================-->	
<link rel="icon" type="image/png" href="images/icons/minsu-icon.ico"/>
<!--===============================================================================================-->
	<link rel="stylesheet" type="text/css" href="vendor/bootstrap/css/bootstrap.min.css">
<!--===============================================================================================-->
	<link rel="stylesheet" type="text/css" href="fonts/font-awesome-4.7.0/css/font-awesome.min.css">
<!--===============================================================================================-->
	<link rel="stylesheet" type="text/css" href="fonts/iconic/css/material-design-iconic-font.min.css">
<!--===============================================================================================-->
	<link rel="stylesheet" type="text/css" href="vendor/animate/animate.css">
<!--===============================================================================================-->	
	<link rel="stylesheet" type="text/css" href="vendor/css-hamburgers/hamburgers.min.css">
<!--===============================================================================================-->
	<link rel="stylesheet" type="text/css" href="vendor/animsition/css/animsition.min.css">
<!--===============================================================================================-->
	<link rel="stylesheet" type="text/css" href="vendor/select2/select2.min.css">
<!--===============================================================================================-->	
	<link rel="stylesheet" type="text/css" href="vendor/daterangepicker/daterangepicker.css">
<!--===============================================================================================-->
	<link rel="stylesheet" type="text/css" href="css/util.css">
	<link rel="stylesheet" type="text/css" href="css/main.css">
<!--===============================================================================================-->
</head>
<body>
<div class="limiter" style="width: 100%;">
		<div class="container-login100" style="width: 100%;">
			<div class="wrap-login100 p-l-55 p-r-55 p-t-65 p-b-54" style="width: 100%;">
                <center><h4 style="font-weight: bold;">VIEW RECORD</h4><br></center>
                    <div class="form-group">
                        <label class="label-input100">Last Name</label>
                        <p class="input100"><b><?php echo $row["Last_Name"]; ?></b></p>
                    </div>
                    <div class="form-group">
                        <label class="label-input100">First Name</label>
                        <p class="input100"><b><?php echo $row["First_Name"]; ?></b></p>
                    </div>
                    <div class="form-group">
                        <label class="label-input100">Middle Initial</label>
                        <p class="input100"><b><?php echo $row["Middle_Initial"]; ?></b></p>
                    </div>
                    <div class="form-group">
                        <label class="label-input100">Birthdate</label>
                        <p class="input100"><b><?php echo $row["Birthdate"]; ?></b></p>
                    </div>
                    <div class="form-group">
                        <label class="label-input100">Gender</label>
                        <p class="input100"><b><?php echo $row["Gender"]; ?></b></p>
                    </div>
                    <div class="form-group">
                        <label class="label-input100">Address</label>
                        <p class="input100"><b><?php echo $row["Address"]; ?></b></p>
                    </div>
                    <div class="form-group">
                        <label class="label-input100">Contact Number</label>
                        <p class="input100"><b><?php echo $row["Contact_Number"]; ?></b></p>
                    </div>
                    <div class="form-group">
                        <label class="label-input100">Email</label>
                        <p class="input100"><b><?php echo $row["Email"]; ?></b></p>
                    </div>
                    <div class="form-group">
                        <label class="label-input100">Password</label>
                        <p class="input100"><b><?php echo $decrypted_pass; ?> (encrypted)</b></p>
                    </div>
                    <div class="form-group">
                        <label class="label-input100">Usertype</label>
                        <p class="input100"><b><?php echo $row["Usertype"]; ?></b></p>
                    </div>
                    <p><a href="accounts_main-page.php" class="btn btn-primary" style="background-color: gray; width: 150px; margin-top: 5px; float: right; border-radius: 5px; border-color: gray;">Back</a></p>
            </div>        
        </div>
    </div>
</body>
</html>