<?php include('session.php') ?>
<?php include('config.php')?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Water Supply Schedule | Pilar Water District</title>
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:400,400i,700&display=swap" rel="stylesheet">
    <link href="css/bootstrap.css" rel="stylesheet">
    <link href="css/fontawesome-all.css" rel="stylesheet">
    <link href="css/swiper.css" rel="stylesheet">
    <link href="css/magnific-popup.css" rel="stylesheet">
    <link href="css/sstyle.css" rel="stylesheet">
    <link href="css/pme_style.css" rel="stylesheet">
    <link href="css/mystyle.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/css/bootstrap.min.css">
    <link rel="icon" href="images/logo_2.png">
    <style>
        @font-face {
            font-family:"Berkshire Swash";
            src: url("css/berkshireswash-regular.ttf") format("truetype");
        }
        .schedule-card {
            background-color: white;
            border-radius: 15px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            padding: 20px;
            margin-bottom: 20px;
        }
        .barangay-tab {
            cursor: pointer;
            transition: all 0.3s;
            padding: 8px 15px;
            margin: 5px;
            border-radius: 20px;
            background-color: #f0f0f0;
            font-size: 14px;
        }
        .barangay-tab:hover {
            background-color: #d0e3ff;
        }
        .barangay-tab.active {
            background-color: #0073e6;
            color: white;
        }
        .schedule-table {
            width: 100%;
            border-collapse: collapse;
        }
        .schedule-table th {
            background-color: #0073e6;
            color: white;
            position: sticky;
            top: 0;
        }
        .schedule-table th, .schedule-table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        .schedule-table tr:hover {
            background-color: #f5f5f5;
        }
        .no-schedule {
            text-align: center;
            padding: 20px;
            color: #666;
        }
        .tab-container {
            display: flex;
            flex-wrap: wrap;
            gap: 5px;
            margin-bottom: 20px;
        }
        .badge-regular {
            background-color: #28a745;
        }
        .badge-limited {
            background-color: #ffc107;
            color: #212529;
        }
        .badge-interrupted {
            background-color: #dc3545;
        }
    </style>
</head>
<body style="background-image: url('images/blue_bg.jfif'); background-size: cover; background-repeat: no-repeat; background-attachment: fixed;">

    <nav class="navbar navbar-expand-lg navbar-dark navbar-custom fixed-top" style="background-color: #8c2b26;">
        <div class="container">
            <a class="navbar-brand logo-image" href="home.php"><img src="images/logo_1.jpg" alt="alternative" style="border-radius: 50%; height:50px; width: 50px;"></a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarsExampleDefault">
                <span class="navbar-toggler-awesome fas fa-bars"></span>
                <span class="navbar-toggler-awesome fas fa-times"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarsExampleDefault">
                <ul class="navbar-nav ml-auto">
                    <li class="nav-item">
                        <a class="nav-link page-scroll" href="home.php">HOME</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link page-scroll" href="water-consumption.php">WATER CONSUMPTION</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link page-scroll active" href="water-supply-schedule.php">WATER SUPPLY SCHEDULE</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link page-scroll" href="notification_list.php">NOTIFICATIONS</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link page-scroll" href="user-complaint.php">COMPLAINTS</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link page-scroll" href="user-account.php">MY PROFILE</a>
                    </li>
                </ul>
                <span class="nav-item">
                    <a class="btn-outline-sm" href="logout.php">LOG OUT</a>
                </span>
            </div>
        </div>
    </nav>

    <header id="header" class="header" style="background-color: #0073e6; margin-top: -50px; height:300px;">
        <div class="header-content">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 col-xl-5">
                        <div class="text-container">
                            <h1 style="font-size: 50px; font-weight: bold;">Water Supply Schedule</h1>
                            <h2 style="color: #f7ef22;">Plan ahead for water availability</h2>
                        </div>
                    </div>
                    <div class="col-lg-6 col-xl-7">
                        <div class="image-container">
                            <div class="img-wrapper">
                                <img class="img-fluid" src="images/water-schedule.png" alt="water schedule" style="height: 250px;">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <svg class="header-frame" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none" viewBox="0 0 1920 310" style="margin-top: -20px;">
        <defs>
            <style>.cls-1{fill:#0073e6;}</style>
        </defs>
        <path class="cls-1" d="M0,283.054c22.75,12.98,53.1,15.2,70.635,14.808,92.115-2.077,238.3-79.9,354.895-79.938,59.97-.019,106.17,18.059,141.58,34,47.778,21.511,47.778,21.511,90,38.938,28.418,11.731,85.344,26.169,152.992,17.971,68.127-8.255,115.933-34.963,166.492-67.393,37.467-24.032,148.6-112.008,171.753-127.963,27.951-19.26,87.771-81.155,180.71-89.341,72.016-6.343,105.479,12.388,157.434,35.467,69.73,30.976,168.93,92.28,256.514,89.405,100.992-3.315,140.276-41.7,177-64.9V0.24H0V283.054Z"/>
    </svg>

    <div class="container" style="margin-top: 50px; margin-bottom: 100px;">
        <div class="row">
            <div class="col-md-12">
                <div class="schedule-card">
                    <h3 style="color: #0073e6; border-bottom: 2px solid #0073e6; padding-bottom: 10px;">Weekly Water Supply Schedule</h3>
                    
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <h5>Select Barangay:</h5>
                            <div class="tab-container">
                                <div class="barangay-tab active" data-barangay="all">All Barangays</div>
                                <div class="barangay-tab" data-barangay="abas">Abas</div>
                                <div class="barangay-tab" data-barangay="abucay">Abucay</div>
                                <div class="barangay-tab" data-barangay="banuyo">Banuyo (Pob)</div>
                                <div class="barangay-tab" data-barangay="bayasong">Bayasong</div>
                                <div class="barangay-tab" data-barangay="binanuahan">Binanuahan (Pob)</div>
                                <div class="barangay-tab" data-barangay="calongay">Calongay</div>
                                <div class="barangay-tab" data-barangay="dao">Dao (Pob)</div>
                                <div class="barangay-tab" data-barangay="esperanza">Esperanza</div>
                                <div class="barangay-tab" data-barangay="guiron">Guiron</div>
                                <div class="barangay-tab" data-barangay="mabanate">Mabanate</div>
                                <div class="barangay-tab" data-barangay="marifosque">Marifosque (Pob)</div>
                                <div class="barangay-tab" data-barangay="mercedes">Mercedes</div>
                                <div class="barangay-tab" data-barangay="putiao">Putiao</div>
                                <div class="barangay-tab" data-barangay="san_antonio">San Antonio (Sapa)</div>
                                <div class="barangay-tab" data-barangay="san_jose">San Jose</div>
                                <div class="barangay-tab" data-barangay="santa_fe">Santa Fe</div>
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive" style="max-height: 500px; overflow-y: auto;">
                        <table class="schedule-table">
                            <thead>
                                <tr>
                                    <th>Barangay</th>
                                    <th>Day</th>
                                    <th>Time</th>
                                    <th>Duration</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody id="schedule-data">
                                <!-- Sample data - in a real app, this would come from your database -->
                                <tr data-barangay="abas">
                                    <td>Abas</td>
                                    <td>Monday, Wednesday, Friday</td>
                                    <td>6:00 AM - 12:00 PM</td>
                                    <td>6 hours</td>
                                    <td><span class="badge badge-regular">Regular</span></td>
                                </tr>
                                <tr data-barangay="abucay">
                                    <td>Abucay</td>
                                    <td>Tuesday, Thursday, Saturday</td>
                                    <td>6:00 AM - 10:00 AM</td>
                                    <td>4 hours</td>
                                    <td><span class="badge badge-regular">Regular</span></td>
                                </tr>
                                <tr data-barangay="banuyo">
                                    <td>Banuyo (Pob)</td>
                                    <td>Monday, Wednesday, Friday</td>
                                    <td>1:00 PM - 5:00 PM</td>
                                    <td>4 hours</td>
                                    <td><span class="badge badge-regular">Regular</span></td>
                                </tr>
                                <tr data-barangay="bayasong">
                                    <td>Bayasong</td>
                                    <td>Tuesday, Thursday, Saturday</td>
                                    <td>1:00 PM - 6:00 PM</td>
                                    <td>5 hours</td>
                                    <td><span class="badge badge-regular">Regular</span></td>
                                </tr>
                                <tr data-barangay="binanuahan">
                                    <td>Binanuahan (Pob)</td>
                                    <td>Sunday</td>
                                    <td>6:00 AM - 12:00 PM</td>
                                    <td>6 hours</td>
                                    <td><span class="badge badge-limited">Limited</span></td>
                                </tr>
                                <tr data-barangay="calongay">
                                    <td>Calongay</td>
                                    <td>Monday, Wednesday, Friday</td>
                                    <td>6:00 AM - 12:00 PM</td>
                                    <td>6 hours</td>
                                    <td><span class="badge badge-regular">Regular</span></td>
                                </tr>
                                <tr data-barangay="dao">
                                    <td>Dao (Pob)</td>
                                    <td>Tuesday, Thursday, Saturday</td>
                                    <td>6:00 AM - 10:00 AM</td>
                                    <td>4 hours</td>
                                    <td><span class="badge badge-regular">Regular</span></td>
                                </tr>
                                <tr data-barangay="esperanza">
                                    <td>Esperanza</td>
                                    <td>Monday, Wednesday, Friday</td>
                                    <td>1:00 PM - 5:00 PM</td>
                                    <td>4 hours</td>
                                    <td><span class="badge badge-regular">Regular</span></td>
                                </tr>
                                <tr data-barangay="guiron">
                                    <td>Guiron</td>
                                    <td>Tuesday, Thursday, Saturday</td>
                                    <td>1:00 PM - 6:00 PM</td>
                                    <td>5 hours</td>
                                    <td><span class="badge badge-regular">Regular</span></td>
                                </tr>
                                <tr data-barangay="mabanate">
                                    <td>Mabanate</td>
                                    <td>Sunday</td>
                                    <td>6:00 AM - 12:00 PM</td>
                                    <td>6 hours</td>
                                    <td><span class="badge badge-limited">Limited</span></td>
                                </tr>
                                <tr data-barangay="marifosque">
                                    <td>Marifosque (Pob)</td>
                                    <td>Monday, Wednesday, Friday</td>
                                    <td>6:00 AM - 12:00 PM</td>
                                    <td>6 hours</td>
                                    <td><span class="badge badge-regular">Regular</span></td>
                                </tr>
                                <tr data-barangay="mercedes">
                                    <td>Mercedes</td>
                                    <td>Tuesday, Thursday, Saturday</td>
                                    <td>6:00 AM - 10:00 AM</td>
                                    <td>4 hours</td>
                                    <td><span class="badge badge-regular">Regular</span></td>
                                </tr>
                                <tr data-barangay="putiao">
                                    <td>Putiao</td>
                                    <td>Monday, Wednesday, Friday</td>
                                    <td>1:00 PM - 5:00 PM</td>
                                    <td>4 hours</td>
                                    <td><span class="badge badge-regular">Regular</span></td>
                                </tr>
                                <tr data-barangay="san_antonio">
                                    <td>San Antonio (Sapa)</td>
                                    <td>Tuesday, Thursday, Saturday</td>
                                    <td>1:00 PM - 6:00 PM</td>
                                    <td>5 hours</td>
                                    <td><span class="badge badge-regular">Regular</span></td>
                                </tr>
                                <tr data-barangay="san_jose">
                                    <td>San Jose</td>
                                    <td>Sunday</td>
                                    <td>6:00 AM - 12:00 PM</td>
                                    <td>6 hours</td>
                                    <td><span class="badge badge-limited">Limited</span></td>
                                </tr>
                                <tr data-barangay="santa_fe">
                                    <td>Santa Fe</td>
                                    <td>Monday, Wednesday, Friday</td>
                                    <td>6:00 AM - 12:00 PM</td>
                                    <td>6 hours</td>
                                    <td><span class="badge badge-regular">Regular</span></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="schedule-card">
                    <h3 style="color: #0073e6; border-bottom: 2px solid #0073e6; padding-bottom: 10px;">Announcements & Updates</h3>
                    <div class="alert alert-info">
                        <strong>Notice:</strong> Water supply will be temporarily suspended in Marifosque on July 15 for system maintenance.
                    </div>
                    <div class="alert alert-warning">
                        <strong>Advisory:</strong> During summer months, water supply duration may be reduced to 4 hours per scheduled day.
                    </div>
                    <div class="alert alert-danger">
                        <strong>Emergency:</strong> Santa Fe will experience water interruption tomorrow (July 10) from 8AM-4PM due to pipeline repair.
                    </div>
                </div>
            </div>
        </div>
    </div>

    <svg class="footer-frame" data-name="Layer 2" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none" viewBox="0 0 1920 79">
        <defs>
            <style>.cls-2{fill:#0073e6;}</style>
        </defs>
        <path class="cls-2" d="M0,72.427C143,12.138,255.5,4.577,328.644,7.943c147.721,6.8,183.881,60.242,320.83,53.737,143-6.793,167.826-68.128,293-60.9,109.095,6.3,115.68,54.364,225.251,57.319,113.58,3.064,138.8-47.711,251.189-41.8,104.012,5.474,109.713,50.4,197.369,46.572,89.549-3.91,124.375-52.563,227.622-50.155A338.646,338.646,0,0,1,1920,23.467V79.75H0V72.427Z" transform="translate(0 -0.188)"/>
    </svg>
    <div class="footer" style="background-color: #0073e6;">
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center">
                    <p style="color: white; margin-top: 20px;">© 2023 Pilar Water District. All Rights Reserved.</p>
                </div>
            </div>
        </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/popper.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.barangay-tab').click(function() {
                $('.barangay-tab').removeClass('active');
                $(this).addClass('active');
                
                const barangay = $(this).data('barangay');
                
                
                if (barangay === 'all') {
                    $('tbody tr').show();
                } else {
                    $('tbody tr').hide();
                    $(`tbody tr[data-barangay="${barangay}"]`).show();
                }
            });
        });
    </script>
</body>
</html>