<?php include('session.php') ?>
<?php include('config.php')?>
<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Keep the same head section as your home.php -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Water Consumption | Pilar Water District</title>
    <!-- Include all the same CSS files as home.php -->
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:400,400i,700&display=swap&subset=latin-ext" rel="stylesheet">
    <link href="css/bootstrap.css" rel="stylesheet">
    <link href="css/fontawesome-all.css" rel="stylesheet">
    <link href="css/swiper.css" rel="stylesheet">
    <link href="css/magnific-popup.css" rel="stylesheet">
    <link href="css/sstyle.css" rel="stylesheet">
    <link href="css/pme_style.css" rel="stylesheet">
    <link href="css/mystyle.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/css/bootstrap.min.css">
    <!-- Add Chart.js for the consumption graph -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link rel="icon" href="images/logo_2.png">
    <style>
        .consumption-card {
            background-color: white;
            border-radius: 15px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            padding: 20px;
            margin-bottom: 20px;
        }
        .table-responsive {
            background-color: white;
            border-radius: 15px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            padding: 20px;
        }
        .insight-card {
            background-color: #f8f9fa;
            border-left: 4px solid #0073e6;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 15px;
        }
    </style>
</head>
<body style="background-image: url('images/blue_bg.jfif'); background-size: cover; background-repeat: no-repeat; background-attachment: fixed;">

    <!-- Copy the same navigation from home.php -->
    <nav class="navbar navbar-expand-lg navbar-dark navbar-custom fixed-top" style="background-color: #8c2b26;">
        <div class="container">
            <a class="navbar-brand logo-image" href="home.php"><img src="images/logo_1.jpg" alt="alternative" style="border-radius: 50%; height:50px; width: 50px;"></a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarsExampleDefault">
                <span class="navbar-toggler-awesome fas fa-bars"></span>
                <span class="navbar-toggler-awesome fas fa-times"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarsExampleDefault">
                <ul class="navbar-nav ml-auto">
                    <li class="nav-item">
                        <a class="nav-link page-scroll" href="home.php">HOME</a>
                    </li>
                    <li class="nav-item">
                        <a class="active nav-link page-scroll" href="water-consumption.php">WATER CONSUMPTION</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link page-scroll" href="water-supply-schedule.php">WATER SUPPLY SCHEDULE</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link page-scroll" href="notification_list.php">NOTIFICATIONS</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link page-scroll" href="user-complaint.php">COMPLAINTS</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link page-scroll" href="user-account.php">MY PROFILE</a>
                    </li>
                </ul>
                <span class="nav-item">
                    <a class="btn-outline-sm" href="logout.php">LOG OUT</a>
                </span>
            </div>
        </div>
    </nav>

    <!-- Header Section (same as home.php) -->
    <header id="header" class="header" style="background-color: #0073e6; margin-top: -50px; height:300px;">
        <div class="header-content">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 col-xl-5">
                        <div class="text-container">
                            <h1 style="font-size: 50px; font-weight: bold;">Water Consumption Dashboard</h1>
                            <h2 style="color: #f7ef22;">Track your water usage</h2>
                        </div>
                    </div>
                    <div class="col-lg-6 col-xl-7">
                        <div class="image-container">
                            <div class="img-wrapper">
                                <img class="img-fluid" src="../assets/img/meter.png" alt="water meter" style="height: 250px;">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <svg class="header-frame" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none" viewBox="0 0 1920 310" style="margin-top: -20px;">
        <defs>
            <style>.cls-1{fill:#0073e6;}</style>
        </defs>
        <path class="cls-1" d="M0,283.054c22.75,12.98,53.1,15.2,70.635,14.808,92.115-2.077,238.3-79.9,354.895-79.938,59.97-.019,106.17,18.059,141.58,34,47.778,21.511,47.778,21.511,90,38.938,28.418,11.731,85.344,26.169,152.992,17.971,68.127-8.255,115.933-34.963,166.492-67.393,37.467-24.032,148.6-112.008,171.753-127.963,27.951-19.26,87.771-81.155,180.71-89.341,72.016-6.343,105.479,12.388,157.434,35.467,69.73,30.976,168.93,92.28,256.514,89.405,100.992-3.315,140.276-41.7,177-64.9V0.24H0V283.054Z"/>
    </svg>

    <!-- Main Content -->
    <div class="container" style="margin-top: 50px; margin-bottom: 100px;">
        <!-- Current Month Summary -->
        <div class="row">
            <div class="col-md-12">
                <div class="consumption-card">
                    <h3 style="color: #0073e6; border-bottom: 2px solid #0073e6; padding-bottom: 10px;">Your Water Consumption Summary</h3>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="text-center">
                                <h4>Current Month</h4>
                                <h2 style="color: #0073e6; font-size: 2.5rem;">25 m³</h2>
                                <p>12% increase from last month</p>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="text-center">
                                <h4>Average Daily Use</h4>
                                <h2 style="color: #0073e6; font-size: 2.5rem;">0.81 m³</h2>
                                <p>≈ 810 liters per day</p>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="text-center">
                                <h4>Estimated Bill</h4>
                                <h2 style="color: #0073e6; font-size: 2.5rem;">₱450.00</h2>
                                <p>Based on current rates</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Consumption Graph -->
        <div class="row">
            <div class="col-md-12">
                <div class="consumption-card">
                    <h3 style="color: #0073e6; border-bottom: 2px solid #0073e6; padding-bottom: 10px;">12-Month Consumption History</h3>
                    <canvas id="consumptionChart" height="100"></canvas>
                </div>
            </div>
        </div>

        <!-- Consumption Insights -->
        <div class="row">
            <div class="col-md-6">
                <div class="consumption-card">
                    <h3 style="color: #0073e6; border-bottom: 2px solid #0073e6; padding-bottom: 10px;">Consumption Insights</h3>
                    <div class="insight-card">
                        <h5><i class="fas fa-tint mr-2" style="color: #0073e6;"></i> Higher Than Average</h5>
                        <p>Your consumption in June was 15% higher than your 12-month average. This might be due to increased outdoor water use.</p>
                    </div>
                    <div class="insight-card">
                        <h5><i class="fas fa-calendar-check mr-2" style="color: #0073e6;"></i> Seasonal Pattern</h5>
                        <p>Your usage typically increases by 20% during summer months (March-May). Consider water-saving measures during these periods.</p>
                    </div>
                    <div class="insight-card">
                        <h5><i class="fas fa-leaf mr-2" style="color: #0073e6;"></i> Conservation Success</h5>
                        <p>You've reduced consumption by 8% compared to last year. Keep up the good work!</p>
                    </div>
                </div>
            </div>

            <!-- Detailed Consumption Table -->
            <div class="col-md-6">
                <div class="table-responsive">
                    <h3 style="color: #0073e6; border-bottom: 2px solid #0073e6; padding-bottom: 10px;">Monthly Consumption Details</h3>
                    <table class="table table-striped">
                        <thead class="thead-dark">
                            <tr>
                                <th>Month</th>
                                <th>Consumption (m³)</th>
                                <th>Cost (₱)</th>
                                <th>Trend</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>January 2023</td>
                                <td>22</td>
                                <td>396.00</td>
                                <td><i class="fas fa-arrow-down text-success"></i> 5%</td>
                            </tr>
                            <tr>
                                <td>February 2023</td>
                                <td>20</td>
                                <td>360.00</td>
                                <td><i class="fas fa-arrow-down text-success"></i> 9%</td>
                            </tr>
                            <tr>
                                <td>March 2023</td>
                                <td>25</td>
                                <td>450.00</td>
                                <td><i class="fas fa-arrow-up text-danger"></i> 25%</td>
                            </tr>
                            <tr>
                                <td>April 2023</td>
                                <td>28</td>
                                <td>504.00</td>
                                <td><i class="fas fa-arrow-up text-danger"></i> 12%</td>
                            </tr>
                            <tr>
                                <td>May 2023</td>
                                <td>30</td>
                                <td>540.00</td>
                                <td><i class="fas fa-arrow-up text-danger"></i> 7%</td>
                            </tr>
                            <tr>
                                <td>June 2023</td>
                                <td>32</td>
                                <td>576.00</td>
                                <td><i class="fas fa-arrow-up text-danger"></i> 7%</td>
                            </tr>
                            <tr>
                                <td>July 2023</td>
                                <td>27</td>
                                <td>486.00</td>
                                <td><i class="fas fa-arrow-down text-success"></i> 16%</td>
                            </tr>
                            <tr>
                                <td>August 2023</td>
                                <td>25</td>
                                <td>450.00</td>
                                <td><i class="fas fa-arrow-down text-success"></i> 7%</td>
                            </tr>
                            <tr>
                                <td>September 2023</td>
                                <td>23</td>
                                <td>414.00</td>
                                <td><i class="fas fa-arrow-down text-success"></i> 8%</td>
                            </tr>
                            <tr>
                                <td>October 2023</td>
                                <td>21</td>
                                <td>378.00</td>
                                <td><i class="fas fa-arrow-down text-success"></i> 9%</td>
                            </tr>
                            <tr>
                                <td>November 2023</td>
                                <td>20</td>
                                <td>360.00</td>
                                <td><i class="fas fa-arrow-down text-success"></i> 5%</td>
                            </tr>
                            <tr>
                                <td>December 2023</td>
                                <td>24</td>
                                <td>432.00</td>
                                <td><i class="fas fa-arrow-up text-danger"></i> 20%</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer (same as home.php) -->
    <svg class="footer-frame" data-name="Layer 2" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none" viewBox="0 0 1920 79">
        <defs>
            <style>.cls-2{fill:#0073e6;}</style>
        </defs>
        <path class="cls-2" d="M0,72.427C143,12.138,255.5,4.577,328.644,7.943c147.721,6.8,183.881,60.242,320.83,53.737,143-6.793,167.826-68.128,293-60.9,109.095,6.3,115.68,54.364,225.251,57.319,113.58,3.064,138.8-47.711,251.189-41.8,104.012,5.474,109.713,50.4,197.369,46.572,89.549-3.91,124.375-52.563,227.622-50.155A338.646,338.646,0,0,1,1920,23.467V79.75H0V72.427Z" transform="translate(0 -0.188)"/>
    </svg>
    <div class="footer" style="background-color: #0073e6;">
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center">
                    <p style="color: white; margin-top: 20px;">© 2023 Pilar Water District. All Rights Reserved.</p>
                </div>
            </div>
        </div>
    </div>

    <!-- JavaScript -->
    <script src="js/jquery.min.js"></script>
    <script src="js/popper.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/jquery.easing.min.js"></script>
    <script src="js/swiper.min.js"></script>
    <script src="js/jquery.magnific-popup.js"></script>
    <script src="js/validator.min.js"></script>
    <script src="js/scripts.js"></script>
    
    <!-- Chart.js Implementation -->
    <script>
        // Consumption Chart
        const ctx = document.getElementById('consumptionChart').getContext('2d');
        const consumptionChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                datasets: [{
                    label: 'Water Consumption (m³)',
                    data: [22, 20, 25, 28, 30, 32, 27, 25, 23, 21, 20, 24],
                    backgroundColor: 'rgba(0, 115, 230, 0.2)',
                    borderColor: 'rgba(0, 115, 230, 1)',
                    borderWidth: 3,
                    tension: 0.3,
                    fill: true
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        position: 'top',
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                return context.parsed.y + ' m³';
                            }
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        title: {
                            display: true,
                            text: 'Cubic Meters (m³)'
                        }
                    }
                }
            }
        });
    </script>
</body>
</html>