<?php 
include('session.php');
include('config.php');

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

$user_email = $_SESSION['login_user'];

// Query for both regular notifications and consumption alerts
$sql_notifications = "SELECT id, title, message, status, date_created, 'system' as source 
                      FROM notifications 
                      WHERE email='$user_email' 
                      
                      UNION ALL
                      
                      SELECT id, CONCAT('High Water Usage - ', month) as title, 
                             message, 'unread' as status, created_at as date_created, 'consumption' as source
                      FROM notified_emails 
                      WHERE username='$user_email' AND notification_type = 'high_consumption'
                      
                      ORDER BY date_created DESC";

$result_notifications = mysqli_query($db, $sql_notifications);
$unread_count = 0;

if(mysqli_num_rows($result_notifications) > 0) {
    while($notification = mysqli_fetch_assoc($result_notifications)) {
        if($notification['status'] == 'unread') $unread_count++;
    }
    mysqli_data_seek($result_notifications, 0);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Notification List | Pilar Water District</title>
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:400,400i,700&display=swap" rel="stylesheet">
    <link href="css/bootstrap.css" rel="stylesheet">
    <link href="css/fontawesome-all.css" rel="stylesheet">
    <link href="css/swiper.css" rel="stylesheet">
    <link href="css/magnific-popup.css" rel="stylesheet">
    <link href="css/sstyle.css" rel="stylesheet">
    <link href="css/pme_style.css" rel="stylesheet">
    <link href="css/mystyle.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/css/bootstrap.min.css">
    <link rel="icon" href="images/logo_2.png">
    <style>
        @font-face {
            font-family:"Berkshire Swash";
            src: url("css/berkshireswash-regular.ttf") format("truetype");
        }
        .schedule-card {
            background-color: white;
            border-radius: 15px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            padding: 20px;
            margin-bottom: 20px;
        }
        .notification-card {
            background-color: white;
            border-radius: 10px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            padding: 15px;
            margin-bottom: 15px;
            transition: all 0.3s;
            border-left: 4px solid transparent;
        }
        .notification-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .unread-notification {
            border-left: 4px solid #0073e6;
            background-color: #f8f9fa;
        }
        .consumption-notification {
            border-left: 4px solid #28a745;
        }
        .modal-content {
            border-radius: 15px;
            border: none;
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }
        .modal-header {
            background-color: #0073e6;
            color: white;
            border-radius: 15px 15px 0 0;
        }
        .badge-unread {
            background-color: #dc3545;
        }
        .badge-read {
            background-color: #6c757d;
        }
        .badge-consumption {
            background-color: #28a745;
        }
    </style>
</head>
<body style="background-image: url('images/blue_bg.jfif'); background-size: cover; background-repeat: no-repeat; background-attachment: fixed;">

    <nav class="navbar navbar-expand-lg navbar-dark navbar-custom fixed-top" style="background-color: #8c2b26;">
        <div class="container">
            <a class="navbar-brand logo-image" href="home.php"><img src="images/logo_1.jpg" alt="alternative" style="border-radius: 50%; height:50px; width: 50px;"></a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarsExampleDefault">
                <span class="navbar-toggler-awesome fas fa-bars"></span>
                <span class="navbar-toggler-awesome fas fa-times"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarsExampleDefault">
                <ul class="navbar-nav ml-auto">
                    <li class="nav-item">
                        <a class="nav-link page-scroll" href="home.php">HOME</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link page-scroll" href="water-consumption.php">WATER CONSUMPTION</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link page-scroll" href="water-supply-schedule.php">WATER SUPPLY SCHEDULE</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link page-scroll active" href="notification_list.php">NOTIFICATIONS 
                            <?php if($unread_count > 0): ?>
                                <span class="badge badge-light"><?php echo $unread_count; ?></span>
                            <?php endif; ?>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link page-scroll" href="user-complaint.php">COMPLAINTS</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link page-scroll" href="user-account.php">MY PROFILE</a>
                    </li>
                </ul>
                <span class="nav-item">
                    <a class="btn-outline-sm" href="logout.php">LOG OUT</a>
                </span>
            </div>
        </div>
    </nav>

    <header id="header" class="header" style="background-color: #0073e6; margin-top: -50px; height:250px;">
        <div class="header-content">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 col-xl-5">
                        <div class="text-container">
                            <h1 style="font-size: 50px; font-weight: bold;">Notifications</h1>
                            <h2 style="color: #f7ef22;">Stay updated with water service alerts</h2>
                        </div>
                    </div>
                    <div class="col-lg-6 col-xl-7">
                        <div class="image-container">
                            <div class="img-wrapper">
                                <img class="img-fluid" src="images/notifications.png" alt="notifications" style="height: 180px;">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <svg class="header-frame" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none" viewBox="0 0 1920 310" style="margin-top: -20px;">
        <defs>
            <style>.cls-1{fill:#0073e6;}</style>
        </defs>
        <path class="cls-1" d="M0,283.054c22.75,12.98,53.1,15.2,70.635,14.808,92.115-2.077,238.3-79.9,354.895-79.938,59.97-.019,106.17,18.059,141.58,34,47.778,21.511,47.778,21.511,90,38.938,28.418,11.731,85.344,26.169,152.992,17.971,68.127-8.255,115.933-34.963,166.492-67.393,37.467-24.032,148.6-112.008,171.753-127.963,27.951-19.26,87.771-81.155,180.71-89.341,72.016-6.343,105.479,12.388,157.434,35.467,69.73,30.976,168.93,92.28,256.514,89.405,100.992-3.315,140.276-41.7,177-64.9V0.24H0V283.054Z"/>
    </svg>

    <div class="container" style="margin-top: 50px; margin-bottom: 100px;">
        <div class="row">
            <div class="col-md-12">
                <div class="schedule-card">
                    <h3 style="color: #0073e6; border-bottom: 2px solid #0073e6; padding-bottom: 10px;">Your Notifications</h3>
                    
                    <div class="row">
                        <?php if(mysqli_num_rows($result_notifications) > 0): ?>
                            <?php while ($notification = mysqli_fetch_assoc($result_notifications)): ?>
                                <div class="col-md-6 mb-3">
                                    <div class="notification-card 
                                        <?php echo ($notification['status'] == 'unread') ? 'unread-notification' : ''; ?>
                                        <?php echo ($notification['source'] == 'consumption') ? 'consumption-notification' : ''; ?>">
                                        <div class="d-flex justify-content-between align-items-start">
                                            <h5><?php echo htmlspecialchars($notification['title']); ?></h5>
                                            <div>
                                                <?php if($notification['source'] == 'consumption'): ?>
                                                    <span class="badge badge-consumption mr-1">Consumption</span>
                                                <?php endif; ?>
                                                <?php if($notification['source'] == 'system'): ?>
                                                    <span class="badge <?php echo ($notification['status'] == 'unread') ? 'badge-unread' : 'badge-read'; ?>">
                                                        <?php echo ucfirst($notification['status']); ?>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <p class="text-muted mb-2">
                                            <i class="far fa-calendar-alt mr-1"></i> 
                                            <?php echo date('M j, Y g:i A', strtotime($notification['date_created'])); ?>
                                        </p>
                                        <button type="button" class="btn btn-primary view-button" 
                                                data-message="<?php echo htmlspecialchars($notification['message']); ?>"
                                                data-id="<?php echo $notification['id']; ?>"
                                                data-source="<?php echo $notification['source']; ?>">
                                            View Message
                                        </button>
                                    </div>
                                </div>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <div class="col-12">
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle mr-2"></i> No notifications found for your account.
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Message Modal -->
    <div class="modal fade" id="messageModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Notification Message</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <pre style="white-space: pre-wrap; font-family: inherit;" id="modalMessage"></pre>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <svg class="footer-frame" data-name="Layer 2" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none" viewBox="0 0 1920 79">
        <defs>
            <style>.cls-2{fill:#0073e6;}</style>
        </defs>
        <path class="cls-2" d="M0,72.427C143,12.138,255.5,4.577,328.644,7.943c147.721,6.8,183.881,60.242,320.83,53.737,143-6.793,167.826-68.128,293-60.9,109.095,6.3,115.68,54.364,225.251,57.319,113.58,3.064,138.8-47.711,251.189-41.8,104.012,5.474,109.713,50.4,197.369,46.572,89.549-3.91,124.375-52.563,227.622-50.155A338.646,338.646,0,0,1,1920,23.467V79.75H0V72.427Z" transform="translate(0 -0.188)"/>
    </svg>
    <div class="footer" style="background-color: #0073e6;">
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center">
                    <p style="color: white; margin-top: 20px;">© 2023 Pilar Water District. All Rights Reserved.</p>
                </div>
            </div>
        </div>
    </div>

    <script src="js/jquery.min.js"></script>
    <script src="js/popper.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.view-button').click(function() {
                const message = $(this).data('message');
                $('#modalMessage').text(message);
                $('#messageModal').modal('show');
                
                // Only mark as read if it's a system notification (not consumption)
                if($(this).closest('.unread-notification').length && $(this).data('source') === 'system') {
                    const notificationId = $(this).data('id');
                    const notificationCard = $(this).closest('.notification-card');
                    
                    $.post('mark_as_read.php', { id: notificationId }, function() {
                        notificationCard.removeClass('unread-notification');
                        notificationCard.find('.badge')
                            .removeClass('badge-unread')
                            .addClass('badge-read')
                            .text('read');
                        
                        // Update unread count in navbar
                        const unreadBadge = $('.nav-item .active .badge');
                        if(unreadBadge.length) {
                            const count = parseInt(unreadBadge.text());
                            if(count > 1) {
                                unreadBadge.text(count - 1);
                            } else {
                                unreadBadge.remove();
                            }
                        }
                    });
                }
            });
        });
    </script>
</body>
</html>