#!/bin/bash

# PSAU GAD System - Setup Script
# This script automates the installation process

echo "=========================================="
echo "PSAU GAD System - Setup Script"
echo "=========================================="
echo ""

# Colors for output
GREEN='\033[0;32m'
RED='\033[0;31m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

# Check if running from correct directory
if [ ! -f "config/config.php" ]; then
    echo -e "${RED}Error: Please run this script from the GAD directory${NC}"
    exit 1
fi

echo "Step 1: Creating directories..."
mkdir -p uploads/profiles uploads/certificates uploads/resources uploads/qr_codes logs
chmod -R 777 uploads logs
echo -e "${GREEN}✓ Directories created${NC}"
echo ""

echo "Step 2: Checking Composer..."
if ! command -v composer &> /dev/null; then
    echo -e "${RED}✗ Composer not found${NC}"
    echo "Please install Composer from https://getcomposer.org/"
    exit 1
fi
echo -e "${GREEN}✓ Composer found${NC}"
echo ""

echo "Step 3: Installing dependencies..."
composer install --no-interaction
if [ $? -eq 0 ]; then
    echo -e "${GREEN}✓ Dependencies installed${NC}"
else
    echo -e "${RED}✗ Failed to install dependencies${NC}"
    exit 1
fi
echo ""

echo "Step 4: Checking MySQL connection..."
mysql -u root -e "SELECT 1" &> /dev/null
if [ $? -eq 0 ]; then
    echo -e "${GREEN}✓ MySQL is accessible${NC}"
else
    echo -e "${YELLOW}⚠ MySQL connection failed. Make sure MySQL is running in XAMPP${NC}"
fi
echo ""

echo "Step 5: Creating database..."
read -p "Do you want to create the database now? (y/n): " -n 1 -r
echo ""
if [[ $REPLY =~ ^[Yy]$ ]]; then
    mysql -u root < database/schema.sql
    if [ $? -eq 0 ]; then
        echo -e "${GREEN}✓ Database created successfully${NC}"
    else
        echo -e "${RED}✗ Failed to create database${NC}"
        echo "You can manually import database/schema.sql in phpMyAdmin"
    fi
else
    echo -e "${YELLOW}⚠ Skipped database creation${NC}"
    echo "Remember to import database/schema.sql manually"
fi
echo ""

echo "Step 6: Creating admin account..."
read -p "Do you want to create an admin account? (y/n): " -n 1 -r
echo ""
if [[ $REPLY =~ ^[Yy]$ ]]; then
    mysql -u root gad_system << EOF
INSERT INTO users (email, password_hash, role, is_psau_account, is_approved, is_active)
VALUES ('admin@psau.edu.ph', '\$2y\$10\$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', 1, 1, 1);

INSERT INTO employee_profiles (user_id, first_name, last_name, gender, category)
VALUES (LAST_INSERT_ID(), 'Admin', 'User', 'Other', 'Other');
EOF
    if [ $? -eq 0 ]; then
        echo -e "${GREEN}✓ Admin account created${NC}"
        echo "  Email: admin@psau.edu.ph"
        echo "  Password: password"
    else
        echo -e "${RED}✗ Failed to create admin account${NC}"
    fi
else
    echo -e "${YELLOW}⚠ Skipped admin account creation${NC}"
fi
echo ""

echo "=========================================="
echo -e "${GREEN}Setup Complete!${NC}"
echo "=========================================="
echo ""
echo "Next steps:"
echo "1. Make sure XAMPP Apache and MySQL are running"
echo "2. Access the system at: http://localhost/GAD"
echo "3. Login with: admin@psau.edu.ph / password"
echo "4. Configure SMTP settings in config/config.php"
echo ""
echo "Documentation:"
echo "- README.md - Project overview"
echo "- INSTALLATION_GUIDE.md - Detailed setup"
echo "- QUICK_START.md - Quick reference"
echo ""
echo -e "${GREEN}Happy coding! 🚀${NC}"

