<?php
require_once '../config/config.php';

// Require admin login
requireRole('secretariat');

$pageTitle = 'GAD Reports - Secretariat - PSAU GAD';
$db = getDB();

// Get statistics for reports
$stmt = $db->query("SELECT COUNT(*) as count FROM activities WHERE is_active = 1");
$totalActivities = $stmt->fetch()['count'];

$stmt = $db->query("SELECT COUNT(*) as count FROM users WHERE role = 'employee'");
$totalEmployees = $stmt->fetch()['count'];

$stmt = $db->query("SELECT COUNT(*) as count FROM activity_registrations WHERE status = 'approved'");
$totalRegistrations = $stmt->fetch()['count'];

$stmt = $db->query("SELECT COUNT(*) as count FROM certificates");
$totalCertificates = $stmt->fetch()['count'];

include '../includes/header.php';
include '../includes/navbar.php';
?>

<div class="min-h-screen bg-gray-50 py-8">
    <div class="container mx-auto px-4">
        <!-- Page Header -->
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-gray-900 mb-2">
                <i class="fas fa-file-alt text-secretariat mr-3"></i>
                GAD Reports
            </h1>
            <p class="text-gray-600">Generate and view various GAD reports</p>
        </div>

        <!-- Statistics Overview -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
            <div class="bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl shadow-lg p-6 text-white">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-blue-100 text-sm mb-1">Total Activities</p>
                        <h3 class="text-4xl font-bold"><?php echo $totalActivities; ?></h3>
                    </div>
                    <div class="w-16 h-16 bg-white bg-opacity-20 rounded-full flex items-center justify-center">
                        <i class="fas fa-calendar-alt text-3xl"></i>
                    </div>
                </div>
            </div>

            <div class="bg-gradient-to-br from-green-500 to-green-600 rounded-xl shadow-lg p-6 text-white">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-green-100 text-sm mb-1">Total Employees</p>
                        <h3 class="text-4xl font-bold"><?php echo $totalEmployees; ?></h3>
                    </div>
                    <div class="w-16 h-16 bg-white bg-opacity-20 rounded-full flex items-center justify-center">
                        <i class="fas fa-users text-3xl"></i>
                    </div>
                </div>
            </div>

            <div class="bg-gradient-to-br from-purple-500 to-purple-600 rounded-xl shadow-lg p-6 text-white">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-purple-100 text-sm mb-1">Total Registrations</p>
                        <h3 class="text-4xl font-bold"><?php echo $totalRegistrations; ?></h3>
                    </div>
                    <div class="w-16 h-16 bg-white bg-opacity-20 rounded-full flex items-center justify-center">
                        <i class="fas fa-clipboard-list text-3xl"></i>
                    </div>
                </div>
            </div>

            <div class="bg-gradient-to-br from-yellow-500 to-yellow-600 rounded-xl shadow-lg p-6 text-white">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-yellow-100 text-sm mb-1">Certificates Issued</p>
                        <h3 class="text-4xl font-bold"><?php echo $totalCertificates; ?></h3>
                    </div>
                    <div class="w-16 h-16 bg-white bg-opacity-20 rounded-full flex items-center justify-center">
                        <i class="fas fa-certificate text-3xl"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Analytics -->
        <div class="mb-8">
            <h2 class="text-2xl font-bold text-gray-900 mb-4">
                <i class="fas fa-chart-line text-secretariat mr-2"></i>
                Analytics & Insights
            </h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <!-- Activity Analytics -->
                <div class="bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-xl transition">
                    <div class="p-6">
                        <div class="flex items-center mb-4">
                            <div class="w-12 h-12 bg-yellow-100 rounded-lg flex items-center justify-center mr-4">
                                <i class="fas fa-chart-line text-yellow-600 text-xl"></i>
                            </div>
                            <div>
                                <h3 class="text-lg font-bold text-gray-900">Activity Analytics</h3>
                                <p class="text-sm text-gray-600">Participation & trends</p>
                            </div>
                        </div>
                        <p class="text-gray-600 text-sm mb-4">
                            Comprehensive insights into activity participation, registration trends, and department engagement.
                        </p>
                        <a href="activity-analytics.php" class="block w-full bg-secretariat text-white px-4 py-2 rounded-lg hover:bg-secretariat-dark transition text-center font-semibold">
                            <i class="fas fa-chart-bar mr-2"></i> View Analytics
                        </a>
                    </div>
                </div>

                <!-- Evaluation Analytics -->
                <div class="bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-xl transition">
                    <div class="p-6">
                        <div class="flex items-center mb-4">
                            <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center mr-4">
                                <i class="fas fa-star text-green-500 text-xl"></i>
                            </div>
                            <div>
                                <h3 class="text-lg font-bold text-gray-900">Evaluation Analytics</h3>
                                <p class="text-sm text-gray-600">Feedback & ratings</p>
                            </div>
                        </div>
                        <p class="text-gray-600 text-sm mb-4">
                            View evaluation results, ratings, and feedback from participants across all activities.
                        </p>
                        <a href="evaluation-management.php" class="block w-full bg-secretariat text-white px-4 py-2 rounded-lg hover:bg-secretariat-dark transition text-center font-semibold">
                            <i class="fas fa-chart-pie mr-2"></i> View Evaluations
                        </a>
                    </div>
                </div>

                <!-- Test Analytics -->
                <div class="bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-xl transition">
                    <div class="p-6">
                        <div class="flex items-center mb-4">
                            <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center mr-4">
                                <i class="fas fa-clipboard-check text-purple-500 text-xl"></i>
                            </div>
                            <div>
                                <h3 class="text-lg font-bold text-gray-900">Test Analytics</h3>
                                <p class="text-sm text-gray-600">Pre/Post test results</p>
                            </div>
                        </div>
                        <p class="text-gray-600 text-sm mb-4">
                            Analyze pre-test and post-test results to measure learning outcomes and knowledge improvement.
                        </p>
                        <a href="pre-test-management.php" class="block w-full bg-secretariat text-white px-4 py-2 rounded-lg hover:bg-secretariat-dark transition text-center font-semibold">
                            <i class="fas fa-chart-area mr-2"></i> View Test Results
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Report Types -->
        <div class="mb-8">
            <h2 class="text-2xl font-bold text-gray-900 mb-4">
                <i class="fas fa-file-alt text-secretariat mr-2"></i>
                GAD Reports
            </h2>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- GAR Report -->
            <div class="bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-xl transition">
                <div class="p-6">
                    <div class="flex items-center mb-4">
                        <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center mr-4">
                            <i class="fas fa-chart-bar text-blue-500 text-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-gray-900">GAR Report</h3>
                            <p class="text-sm text-gray-600">Gender and Development Accomplishment Report</p>
                        </div>
                    </div>
                    <p class="text-gray-600 text-sm mb-4">
                        Auto-generated report from GPB and Monitoring forms showing GAD accomplishments and achievements.
                    </p>
                    <a href="report-gar.php" class="block w-full bg-secretariat text-white px-4 py-2 rounded-lg hover:bg-secretariat-dark transition text-center font-semibold">
                        <i class="fas fa-file-pdf mr-2"></i> Generate GAR Report
                    </a>
                </div>
            </div>

            <!-- Training/Seminar Report -->
            <div class="bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-xl transition">
                <div class="p-6">
                    <div class="flex items-center mb-4">
                        <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center mr-4">
                            <i class="fas fa-graduation-cap text-green-500 text-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-gray-900">Training/Seminar Report</h3>
                            <p class="text-sm text-gray-600">Comprehensive training and seminar data</p>
                        </div>
                    </div>
                    <p class="text-gray-600 text-sm mb-4">
                        Detailed report from attendance, pre/post tests, GPB, and evaluation forms.
                    </p>
                    <a href="report-training.php" class="block w-full bg-secretariat text-white px-4 py-2 rounded-lg hover:bg-secretariat-dark transition text-center font-semibold">
                        <i class="fas fa-file-pdf mr-2"></i> Generate Training Report
                    </a>
                </div>
            </div>

            <!-- Sex Disaggregated Data -->
            <div class="bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-xl transition">
                <div class="p-6">
                    <div class="flex items-center mb-4">
                        <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center mr-4">
                            <i class="fas fa-venus-mars text-purple-500 text-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-gray-900">Sex Disaggregated Data</h3>
                            <p class="text-sm text-gray-600">Gender-based statistical analysis</p>
                        </div>
                    </div>
                    <p class="text-gray-600 text-sm mb-4">
                        Statistical breakdown of employee data by gender and category.
                    </p>
                    <a href="report-sex-disaggregated.php" class="block w-full bg-secretariat text-white px-4 py-2 rounded-lg hover:bg-secretariat-dark transition text-center font-semibold">
                        <i class="fas fa-file-excel mr-2"></i> Generate SDD Report
                    </a>
                </div>
            </div>

            <!-- Supporting Documents -->
            <div class="bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-xl transition">
                <div class="p-6">
                    <div class="flex items-center mb-4">
                        <div class="w-12 h-12 bg-yellow-100 rounded-lg flex items-center justify-center mr-4">
                            <i class="fas fa-folder-open text-yellow-500 text-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-gray-900">Supporting Documents</h3>
                            <p class="text-sm text-gray-600">Document management and archives</p>
                        </div>
                    </div>
                    <p class="text-gray-600 text-sm mb-4">
                        Manage and organize supporting documents for GAD activities.
                    </p>
                    <a href="supporting-documents.php" class="block w-full bg-secretariat text-white px-4 py-2 rounded-lg hover:bg-secretariat-dark transition text-center font-semibold">
                        <i class="fas fa-folder mr-2"></i> Manage Documents
                    </a>
                </div>
            </div>

            <!-- Attendance Report -->
            <div class="bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-xl transition">
                <div class="p-6">
                    <div class="flex items-center mb-4">
                        <div class="w-12 h-12 bg-red-100 rounded-lg flex items-center justify-center mr-4">
                            <i class="fas fa-user-check text-red-500 text-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-gray-900">Attendance Report</h3>
                            <p class="text-sm text-gray-600">Activity attendance summary</p>
                        </div>
                    </div>
                    <p class="text-gray-600 text-sm mb-4">
                        Comprehensive attendance records and statistics for all activities.
                    </p>
                    <a href="report-attendance.php" class="block w-full bg-secretariat text-white px-4 py-2 rounded-lg hover:bg-secretariat-dark transition text-center font-semibold">
                        <i class="fas fa-file-pdf mr-2"></i> Generate Attendance Report
                    </a>
                </div>
            </div>

            <!-- Custom Report -->
            <div class="bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-xl transition">
                <div class="p-6">
                    <div class="flex items-center mb-4">
                        <div class="w-12 h-12 bg-indigo-100 rounded-lg flex items-center justify-center mr-4">
                            <i class="fas fa-cog text-indigo-500 text-xl"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-gray-900">Custom Report</h3>
                            <p class="text-sm text-gray-600">Build your own custom report</p>
                        </div>
                    </div>
                    <p class="text-gray-600 text-sm mb-4">
                        Create custom reports with specific date ranges and filters.
                    </p>
                    <a href="report-custom.php" class="block w-full bg-secretariat text-white px-4 py-2 rounded-lg hover:bg-secretariat-dark transition text-center font-semibold">
                        <i class="fas fa-plus mr-2"></i> Create Custom Report
                    </a>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="bg-white rounded-xl shadow-lg p-6 mt-8">
            <h2 class="text-xl font-bold text-gray-900 mb-4">
                <i class="fas fa-bolt text-secretariat mr-2"></i>
                Quick Actions
            </h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <a href="gpb-form.php" class="flex items-center p-4 border border-gray-200 rounded-lg hover:border-secretariat transition">
                    <i class="fas fa-file-invoice-dollar text-secretariat text-2xl mr-4"></i>
                    <div>
                        <h4 class="font-semibold text-gray-900">GPB Form</h4>
                        <p class="text-sm text-gray-600">Gender Plan & Budget</p>
                    </div>
                </a>
                <a href="monitoring-form.php" class="flex items-center p-4 border border-gray-200 rounded-lg hover:border-secretariat transition">
                    <i class="fas fa-tasks text-secretariat text-2xl mr-4"></i>
                    <div>
                        <h4 class="font-semibold text-gray-900">Monitoring Form</h4>
                        <p class="text-sm text-gray-600">Track Activities</p>
                    </div>
                </a>
                <a href="analytics.php" class="flex items-center p-4 border border-gray-200 rounded-lg hover:border-secretariat transition">
                    <i class="fas fa-chart-line text-secretariat text-2xl mr-4"></i>
                    <div>
                        <h4 class="font-semibold text-gray-900">Analytics</h4>
                        <p class="text-sm text-gray-600">View Insights</p>
                    </div>
                </a>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>

