<?php
require_once 'config/config.php';

// Redirect if already logged in
if (isLoggedIn()) {
    $role = getCurrentUserRole();
    redirect($role . '/dashboard.php');
}

$pageTitle = 'Login - PSAU GAD';
$error = '';
$success = '';

if (isPost()) {
    $email = sanitize(post('email'));
    $password = post('password');
    
    if (empty($email) || empty($password)) {
        $error = 'Please fill in all fields';
    } else {
        $auth = new Auth();
        $result = $auth->login($email, $password);
        
        if ($result['success']) {
            $role = $_SESSION['role'];
            redirect($role . '/dashboard.php');
        } else {
            $error = $result['message'];
        }
    }
}

include 'includes/header.php';
?>

<div class="min-h-screen flex items-center justify-center bg-gradient-to-br from-purple-50 to-purple-100 py-12 px-4 sm:px-6 lg:px-8">
    <div class="max-w-md w-full">
        <!-- Logo and Title -->
        <div class="text-center mb-8">
            <div class="mx-auto w-20 h-20 bg-primary rounded-full flex items-center justify-center mb-4">
                <i class="fas fa-venus-mars text-white text-3xl"></i>
            </div>
            <h2 class="text-3xl font-bold text-gray-900">PSAU GAD System</h2>
            <p class="mt-2 text-gray-600">Sign in to your account</p>
        </div>
        
        <!-- Login Form -->
        <div class="bg-white rounded-2xl shadow-xl p-8">
            <?php if ($error): ?>
                <div class="mb-4 bg-red-50 border-l-4 border-red-500 p-4 rounded">
                    <p class="text-red-700"><i class="fas fa-exclamation-circle mr-2"></i><?php echo $error; ?></p>
                </div>
            <?php endif; ?>
            
            <?php if ($success): ?>
                <div class="mb-4 bg-green-50 border-l-4 border-green-500 p-4 rounded">
                    <p class="text-green-700"><i class="fas fa-check-circle mr-2"></i><?php echo $success; ?></p>
                </div>
            <?php endif; ?>
            
            <form method="POST" action="" class="space-y-6">
                <!-- Email -->
                <div>
                    <label for="email" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-envelope mr-1"></i> Email Address
                    </label>
                    <input type="email" 
                           id="email" 
                           name="email" 
                           required
                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent transition"
                           placeholder="Enter your email"
                           value="<?php echo htmlspecialchars($email ?? ''); ?>">
                </div>
                
                <!-- Password -->
                <div>
                    <label for="password" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-lock mr-1"></i> Password
                    </label>
                    <input type="password" 
                           id="password" 
                           name="password" 
                           required
                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent transition"
                           placeholder="Enter your password">
                </div>
                
                <!-- Remember Me & Forgot Password -->
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <input type="checkbox" 
                               id="remember" 
                               name="remember"
                               class="h-4 w-4 text-primary focus:ring-primary border-gray-300 rounded">
                        <label for="remember" class="ml-2 block text-sm text-gray-700">
                            Remember me
                        </label>
                    </div>
                    <a href="forgot-password.php" class="text-sm text-primary hover:text-primary-dark">
                        Forgot password?
                    </a>
                </div>
                
                <!-- Submit Button -->
                <button type="submit" 
                        class="w-full bg-primary text-white py-3 rounded-lg font-semibold hover:bg-primary-dark transition transform hover:scale-105 btn-animate">
                    <i class="fas fa-sign-in-alt mr-2"></i> Sign In
                </button>
            </form>
            
            <!-- Divider -->
            <div class="mt-6 relative">
                <div class="absolute inset-0 flex items-center">
                    <div class="w-full border-t border-gray-300"></div>
                </div>
                <div class="relative flex justify-center text-sm">
                    <span class="px-2 bg-white text-gray-500">Don't have an account?</span>
                </div>
            </div>
            
            <!-- Register Link -->
            <div class="mt-6">
                <a href="register.php" 
                   class="w-full flex justify-center items-center px-4 py-3 border-2 border-primary text-primary rounded-lg font-semibold hover:bg-primary hover:text-white transition">
                    <i class="fas fa-user-plus mr-2"></i> Create New Account
                </a>
            </div>
            
            <!-- Back to Home -->
            <div class="mt-4 text-center">
                <a href="index.php" class="text-sm text-gray-600 hover:text-primary">
                    <i class="fas fa-arrow-left mr-1"></i> Back to Home
                </a>
            </div>
        </div>
        
        <!-- Info Box -->
        <div class="mt-6 bg-blue-50 border border-blue-200 rounded-lg p-4">
            <p class="text-sm text-blue-800">
                <i class="fas fa-info-circle mr-2"></i>
                <strong>Note:</strong> PSAU email accounts (@psau.edu.ph) are automatically approved. 
                Other accounts require admin approval.
            </p>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>

