<?php
require_once 'config/config.php';

// Redirect to dashboard if already logged in
if (isLoggedIn()) {
    $role = getCurrentUserRole();
    redirect($role . '/dashboard.php');
}

$pageTitle = 'Home - PSAU GAD';
include 'includes/header.php';
include 'includes/navbar.php';
?>

<!-- Hero Section with Banner -->
<section class="bg-gradient-to-r from-purple-600 to-purple-800 text-white py-20">
    <div class="container mx-auto px-4">
        <div class="flex flex-col md:flex-row items-center justify-between">
            <div class="md:w-1/2 mb-8 md:mb-0 fade-in">
                <h1 class="text-4xl md:text-5xl font-bold mb-4">
                    Gender and Development
                </h1>
                <h2 class="text-2xl md:text-3xl mb-6">
                    Information System
                </h2>
                <p class="text-lg mb-8 text-purple-100">
                    Empowering equality, fostering development, and promoting gender-responsive programs at Pampanga State Agricultural University.
                </p>
                <div class="flex flex-wrap gap-4">
                    <a href="register.php" class="bg-white text-purple-600 px-8 py-3 rounded-lg font-semibold hover:bg-gray-100 transition transform hover:scale-105">
                        <i class="fas fa-user-plus mr-2"></i> Get Started
                    </a>
                    <a href="#about" class="bg-purple-700 text-white px-8 py-3 rounded-lg font-semibold hover:bg-purple-800 transition">
                        <i class="fas fa-info-circle mr-2"></i> Learn More
                    </a>
                </div>
            </div>
            <div class="md:w-1/2 flex justify-center fade-in">
                <div class="w-64 h-64 bg-white bg-opacity-20 rounded-full flex items-center justify-center backdrop-blur-sm">
                    <i class="fas fa-venus-mars text-white text-9xl"></i>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Vision, Mission, and Goals -->
<section id="about" class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-12">
            <h2 class="text-3xl font-bold text-gray-900 mb-4">About GAD</h2>
            <div class="w-24 h-1 bg-primary mx-auto"></div>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <!-- Vision -->
            <div class="bg-gradient-to-br from-purple-50 to-purple-100 p-8 rounded-2xl shadow-lg card-hover">
                <div class="w-16 h-16 bg-primary rounded-full flex items-center justify-center mb-4 mx-auto">
                    <i class="fas fa-eye text-white text-2xl"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 mb-4 text-center">Vision</h3>
                <p class="text-gray-700 text-center">
                    A gender-responsive university that promotes equality, equity, and empowerment for all members of the academic community.
                </p>
            </div>
            
            <!-- Mission -->
            <div class="bg-gradient-to-br from-blue-50 to-blue-100 p-8 rounded-2xl shadow-lg card-hover">
                <div class="w-16 h-16 bg-blue-500 rounded-full flex items-center justify-center mb-4 mx-auto">
                    <i class="fas fa-bullseye text-white text-2xl"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 mb-4 text-center">Mission</h3>
                <p class="text-gray-700 text-center">
                    To mainstream gender perspectives in all university programs, policies, and activities through education, advocacy, and capacity building.
                </p>
            </div>
            
            <!-- Goals -->
            <div class="bg-gradient-to-br from-green-50 to-green-100 p-8 rounded-2xl shadow-lg card-hover">
                <div class="w-16 h-16 bg-green-500 rounded-full flex items-center justify-center mb-4 mx-auto">
                    <i class="fas fa-flag text-white text-2xl"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 mb-4 text-center">Goals</h3>
                <p class="text-gray-700 text-center">
                    To create a safe, inclusive, and gender-fair environment that enables everyone to reach their full potential.
                </p>
            </div>
        </div>
    </div>
</section>

<!-- History Section -->
<section class="py-16 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-gray-900 mb-4">Our History</h2>
                <div class="w-24 h-1 bg-primary mx-auto"></div>
            </div>
            
            <div class="bg-white rounded-2xl shadow-lg p-8">
                <div class="prose max-w-none">
                    <p class="text-gray-700 mb-4">
                        The Gender and Development (GAD) Program at Pampanga State Agricultural University was established to comply with the Magna Carta of Women and other gender-related laws and policies in the Philippines.
                    </p>
                    <p class="text-gray-700 mb-4">
                        Since its inception, the GAD Program has been instrumental in promoting gender equality and women's empowerment through various activities, seminars, and training programs for faculty, staff, and students.
                    </p>
                    <p class="text-gray-700">
                        Today, the GAD Information System serves as a comprehensive platform for managing activities, tracking participation, and generating reports to ensure the continued success of our gender and development initiatives.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Upcoming Activities Preview -->
<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-12">
            <h2 class="text-3xl font-bold text-gray-900 mb-4">Upcoming Activities</h2>
            <div class="w-24 h-1 bg-primary mx-auto mb-4"></div>
            <p class="text-gray-600">Join us in our upcoming GAD activities and seminars</p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Sample Activity Cards -->
            <div class="bg-white border border-gray-200 rounded-2xl shadow-lg overflow-hidden card-hover">
                <div class="bg-gradient-to-r from-purple-500 to-purple-600 p-6 text-white">
                    <div class="flex items-center justify-between mb-2">
                        <span class="bg-white bg-opacity-20 px-3 py-1 rounded-full text-sm">Upcoming</span>
                        <i class="fas fa-calendar-alt text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold">Gender Sensitivity Training</h3>
                </div>
                <div class="p-6">
                    <div class="flex items-center text-gray-600 mb-3">
                        <i class="fas fa-calendar mr-2 text-primary"></i>
                        <span>March 28, 2025</span>
                    </div>
                    <div class="flex items-center text-gray-600 mb-3">
                        <i class="fas fa-clock mr-2 text-primary"></i>
                        <span>9:00 AM - 4:00 PM</span>
                    </div>
                    <div class="flex items-center text-gray-600 mb-4">
                        <i class="fas fa-map-marker-alt mr-2 text-primary"></i>
                        <span>PSAU Main Campus</span>
                    </div>
                    <a href="login.php" class="block w-full text-center bg-primary text-white py-2 rounded-lg hover:bg-primary-dark transition">
                        Register Now
                    </a>
                </div>
            </div>
            
            <!-- More sample cards can be added here -->
            <div class="bg-white border border-gray-200 rounded-2xl shadow-lg overflow-hidden card-hover">
                <div class="bg-gradient-to-r from-blue-500 to-blue-600 p-6 text-white">
                    <div class="flex items-center justify-between mb-2">
                        <span class="bg-white bg-opacity-20 px-3 py-1 rounded-full text-sm">Upcoming</span>
                        <i class="fas fa-calendar-alt text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold">Women Empowerment Seminar</h3>
                </div>
                <div class="p-6">
                    <div class="flex items-center text-gray-600 mb-3">
                        <i class="fas fa-calendar mr-2 text-primary"></i>
                        <span>April 15, 2025</span>
                    </div>
                    <div class="flex items-center text-gray-600 mb-3">
                        <i class="fas fa-clock mr-2 text-primary"></i>
                        <span>1:00 PM - 5:00 PM</span>
                    </div>
                    <div class="flex items-center text-gray-600 mb-4">
                        <i class="fas fa-map-marker-alt mr-2 text-primary"></i>
                        <span>Conference Hall</span>
                    </div>
                    <a href="login.php" class="block w-full text-center bg-primary text-white py-2 rounded-lg hover:bg-primary-dark transition">
                        Register Now
                    </a>
                </div>
            </div>
            
            <div class="bg-white border border-gray-200 rounded-2xl shadow-lg overflow-hidden card-hover">
                <div class="bg-gradient-to-r from-green-500 to-green-600 p-6 text-white">
                    <div class="flex items-center justify-between mb-2">
                        <span class="bg-white bg-opacity-20 px-3 py-1 rounded-full text-sm">Upcoming</span>
                        <i class="fas fa-calendar-alt text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-bold">Anti-VAWC Workshop</h3>
                </div>
                <div class="p-6">
                    <div class="flex items-center text-gray-600 mb-3">
                        <i class="fas fa-calendar mr-2 text-primary"></i>
                        <span>May 10, 2025</span>
                    </div>
                    <div class="flex items-center text-gray-600 mb-3">
                        <i class="fas fa-clock mr-2 text-primary"></i>
                        <span>8:00 AM - 12:00 PM</span>
                    </div>
                    <div class="flex items-center text-gray-600 mb-4">
                        <i class="fas fa-map-marker-alt mr-2 text-primary"></i>
                        <span>Auditorium</span>
                    </div>
                    <a href="login.php" class="block w-full text-center bg-primary text-white py-2 rounded-lg hover:bg-primary-dark transition">
                        Register Now
                    </a>
                </div>
            </div>
        </div>
        
        <div class="text-center mt-8">
            <a href="login.php" class="inline-block bg-primary text-white px-8 py-3 rounded-lg font-semibold hover:bg-primary-dark transition">
                View All Activities <i class="fas fa-arrow-right ml-2"></i>
            </a>
        </div>
    </div>
</section>

<!-- Call to Action -->
<section class="py-16 bg-gradient-to-r from-purple-600 to-purple-800 text-white">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-3xl font-bold mb-4">Ready to Get Started?</h2>
        <p class="text-xl mb-8 text-purple-100">Join our community and participate in GAD activities</p>
        <div class="flex flex-wrap justify-center gap-4">
            <a href="register.php" class="bg-white text-purple-600 px-8 py-3 rounded-lg font-semibold hover:bg-gray-100 transition transform hover:scale-105">
                <i class="fas fa-user-plus mr-2"></i> Create Account
            </a>
            <a href="login.php" class="bg-purple-700 text-white px-8 py-3 rounded-lg font-semibold hover:bg-purple-900 transition">
                <i class="fas fa-sign-in-alt mr-2"></i> Sign In
            </a>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>

