<?php
$currentPage = basename($_SERVER['PHP_SELF']);
$userRole = $_SESSION['role'] ?? 'guest';
$userName = $_SESSION['full_name'] ?? 'Guest';
?>

<nav class="bg-white shadow-lg sticky top-0 z-40">
    <div class="container mx-auto px-4">
        <div class="flex justify-between items-center py-4">
            <!-- Logo and Brand -->
            <div class="flex items-center space-x-4">
                <a href="<?php echo BASE_URL; ?>/index.php" class="flex items-center space-x-3">
                    <div class="w-12 h-12 bg-primary rounded-full flex items-center justify-center">
                        <i class="fas fa-venus-mars text-white text-xl"></i>
                    </div>
                    <div>
                        <h1 class="text-xl font-bold text-gray-800">PSAU GAD</h1>
                        <p class="text-xs text-gray-500">Gender & Development</p>
                    </div>
                </a>
            </div>
            
            <!-- Desktop Navigation -->
            <div class="hidden md:flex items-center space-x-6">
                <?php if ($userRole === 'guest'): ?>
                    <!-- Guest Navigation -->
                    <a href="<?php echo BASE_URL; ?>/index.php" 
                       class="<?php echo $currentPage === 'index.php' ? 'text-primary font-semibold' : 'text-gray-600 hover:text-primary'; ?>">
                        <i class="fas fa-home mr-1"></i> Home
                    </a>
                    <a href="<?php echo BASE_URL; ?>/activities.php" 
                       class="<?php echo $currentPage === 'activities.php' ? 'text-primary font-semibold' : 'text-gray-600 hover:text-primary'; ?>">
                        <i class="fas fa-calendar-alt mr-1"></i> Activities
                    </a>
                    <a href="<?php echo BASE_URL; ?>/contact.php" 
                       class="<?php echo $currentPage === 'contact.php' ? 'text-primary font-semibold' : 'text-gray-600 hover:text-primary'; ?>">
                        <i class="fas fa-envelope mr-1"></i> Contact
                    </a>
                    <a href="<?php echo BASE_URL; ?>/login.php" 
                       class="bg-primary text-white px-4 py-2 rounded-lg hover:bg-primary-dark">
                        <i class="fas fa-sign-in-alt mr-1"></i> Login
                    </a>
                    <a href="<?php echo BASE_URL; ?>/register.php" 
                       class="bg-white text-primary border-2 border-primary px-4 py-2 rounded-lg hover:bg-primary hover:text-white">
                        <i class="fas fa-user-plus mr-1"></i> Register
                    </a>
                    
                <?php elseif ($userRole === 'employee'): ?>
                    <!-- Employee Navigation -->
                    <a href="<?php echo BASE_URL; ?>/employee/dashboard.php" 
                       class="<?php echo strpos($currentPage, 'dashboard') !== false ? 'text-employee font-semibold' : 'text-gray-600 hover:text-employee'; ?>">
                        <i class="fas fa-home mr-1"></i> Home
                    </a>
                    <a href="<?php echo BASE_URL; ?>/employee/activities.php"
                       class="<?php echo strpos($currentPage, 'activities') !== false ? 'text-employee font-semibold' : 'text-gray-600 hover:text-employee'; ?>">
                        <i class="fas fa-calendar-alt mr-1"></i> Activities
                    </a>
                    <a href="<?php echo BASE_URL; ?>/employee/calendar.php"
                       class="<?php echo strpos($currentPage, 'calendar') !== false ? 'text-employee font-semibold' : 'text-gray-600 hover:text-employee'; ?>">
                        <i class="fas fa-calendar-week mr-1"></i> Calendar
                    </a>
                    <a href="<?php echo BASE_URL; ?>/employee/certificates.php"
                       class="<?php echo strpos($currentPage, 'certificates') !== false ? 'text-employee font-semibold' : 'text-gray-600 hover:text-employee'; ?>">
                        <i class="fas fa-certificate mr-1"></i> Certificates
                    </a>
                    <a href="<?php echo BASE_URL; ?>/employee/contact.php" 
                       class="<?php echo strpos($currentPage, 'contact') !== false ? 'text-employee font-semibold' : 'text-gray-600 hover:text-employee'; ?>">
                        <i class="fas fa-envelope mr-1"></i> Contact
                    </a>
                    
                <?php elseif ($userRole === 'admin'): ?>
                    <!-- Admin Navigation -->
                    <a href="<?php echo BASE_URL; ?>/admin/dashboard.php" 
                       class="<?php echo strpos($currentPage, 'dashboard') !== false ? 'text-admin font-semibold' : 'text-gray-600 hover:text-admin'; ?>">
                        <i class="fas fa-tachometer-alt mr-1"></i> Dashboard
                    </a>
                    <a href="<?php echo BASE_URL; ?>/admin/activities.php"
                       class="<?php echo strpos($currentPage, 'activities') !== false ? 'text-admin font-semibold' : 'text-gray-600 hover:text-admin'; ?>">
                        <i class="fas fa-calendar-alt mr-1"></i> Activities
                    </a>
                    <a href="<?php echo BASE_URL; ?>/admin/calendar.php"
                       class="<?php echo strpos($currentPage, 'calendar') !== false ? 'text-admin font-semibold' : 'text-gray-600 hover:text-admin'; ?>">
                        <i class="fas fa-calendar-week mr-1"></i> Calendar
                    </a>
                    <a href="<?php echo BASE_URL; ?>/admin/reports.php"
                       class="<?php echo strpos($currentPage, 'reports') !== false ? 'text-admin font-semibold' : 'text-gray-600 hover:text-admin'; ?>">
                        <i class="fas fa-chart-bar mr-1"></i> Reports
                    </a>
                    <a href="<?php echo BASE_URL; ?>/admin/employees.php" 
                       class="<?php echo strpos($currentPage, 'employees') !== false ? 'text-admin font-semibold' : 'text-gray-600 hover:text-admin'; ?>">
                        <i class="fas fa-users mr-1"></i> Employees
                    </a>
                    
                <?php elseif ($userRole === 'secretariat'): ?>
                    <!-- Secretariat Navigation -->
                    <a href="<?php echo BASE_URL; ?>/secretariat/dashboard.php" 
                       class="<?php echo strpos($currentPage, 'dashboard') !== false ? 'text-secretariat font-semibold' : 'text-gray-600 hover:text-secretariat'; ?>">
                        <i class="fas fa-tachometer-alt mr-1"></i> Dashboard
                    </a>
                    <a href="<?php echo BASE_URL; ?>/secretariat/activities.php"
                       class="<?php echo strpos($currentPage, 'activities') !== false ? 'text-secretariat font-semibold' : 'text-gray-600 hover:text-secretariat'; ?>">
                        <i class="fas fa-calendar-alt mr-1"></i> Activities
                    </a>
                    <a href="<?php echo BASE_URL; ?>/secretariat/calendar.php"
                       class="<?php echo strpos($currentPage, 'calendar') !== false ? 'text-secretariat font-semibold' : 'text-gray-600 hover:text-secretariat'; ?>">
                        <i class="fas fa-calendar-week mr-1"></i> Calendar
                    </a>
                    <a href="<?php echo BASE_URL; ?>/secretariat/attendance.php"
                       class="<?php echo strpos($currentPage, 'attendance') !== false ? 'text-secretariat font-semibold' : 'text-gray-600 hover:text-secretariat'; ?>">
                        <i class="fas fa-clipboard-check mr-1"></i> Attendance
                    </a>
                    <a href="<?php echo BASE_URL; ?>/secretariat/reports.php" 
                       class="<?php echo strpos($currentPage, 'reports') !== false ? 'text-secretariat font-semibold' : 'text-gray-600 hover:text-secretariat'; ?>">
                        <i class="fas fa-chart-bar mr-1"></i> Reports
                    </a>
                <?php endif; ?>
                
                <?php if ($userRole !== 'guest'): ?>
                    <!-- User Dropdown -->
                    <div class="relative group">
                        <button class="flex items-center space-x-2 text-gray-600 hover:text-primary">
                            <div class="w-8 h-8 bg-primary rounded-full flex items-center justify-center">
                                <span class="text-white text-sm font-semibold">
                                    <?php echo strtoupper(substr($userName, 0, 1)); ?>
                                </span>
                            </div>
                            <span><?php echo htmlspecialchars($userName); ?></span>
                            <i class="fas fa-chevron-down text-xs"></i>
                        </button>
                        
                        <!-- Dropdown Menu -->
                        <div class="absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-lg py-2 hidden group-hover:block">
                            <a href="<?php echo BASE_URL; ?>/<?php echo $userRole; ?>/profile.php" 
                               class="block px-4 py-2 text-gray-700 hover:bg-gray-100">
                                <i class="fas fa-user mr-2"></i> Profile
                            </a>
                            <a href="<?php echo BASE_URL; ?>/<?php echo $userRole; ?>/settings.php" 
                               class="block px-4 py-2 text-gray-700 hover:bg-gray-100">
                                <i class="fas fa-cog mr-2"></i> Settings
                            </a>
                            <hr class="my-2">
                            <a href="<?php echo BASE_URL; ?>/logout.php" 
                               class="block px-4 py-2 text-red-600 hover:bg-gray-100">
                                <i class="fas fa-sign-out-alt mr-2"></i> Logout
                            </a>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            
            <!-- Mobile Menu Button -->
            <button id="mobile-menu-btn" class="md:hidden text-gray-600 hover:text-primary">
                <i class="fas fa-bars text-2xl"></i>
            </button>
        </div>
        
        <!-- Mobile Navigation -->
        <div id="mobile-menu" class="hidden md:hidden pb-4">
            <?php if ($userRole === 'guest'): ?>
                <a href="<?php echo BASE_URL; ?>/index.php" class="block py-2 text-gray-600 hover:text-primary">
                    <i class="fas fa-home mr-2"></i> Home
                </a>
                <a href="<?php echo BASE_URL; ?>/activities.php" class="block py-2 text-gray-600 hover:text-primary">
                    <i class="fas fa-calendar-alt mr-2"></i> Activities
                </a>
                <a href="<?php echo BASE_URL; ?>/contact.php" class="block py-2 text-gray-600 hover:text-primary">
                    <i class="fas fa-envelope mr-2"></i> Contact
                </a>
                <a href="<?php echo BASE_URL; ?>/login.php" class="block py-2 text-primary font-semibold">
                    <i class="fas fa-sign-in-alt mr-2"></i> Login
                </a>
                <a href="<?php echo BASE_URL; ?>/register.php" class="block py-2 text-primary font-semibold">
                    <i class="fas fa-user-plus mr-2"></i> Register
                </a>
            <?php else: ?>
                <a href="<?php echo BASE_URL; ?>/<?php echo $userRole; ?>/profile.php" class="block py-2 text-gray-600 hover:text-primary">
                    <i class="fas fa-user mr-2"></i> Profile
                </a>
                <a href="<?php echo BASE_URL; ?>/logout.php" class="block py-2 text-red-600">
                    <i class="fas fa-sign-out-alt mr-2"></i> Logout
                </a>
            <?php endif; ?>
        </div>
    </div>
</nav>

<script>
    // Mobile menu toggle
    document.getElementById('mobile-menu-btn').addEventListener('click', function() {
        const menu = document.getElementById('mobile-menu');
        menu.classList.toggle('hidden');
    });
</script>

