    <!-- Footer -->
    <footer class="bg-gray-800 text-white mt-12">
        <div class="container mx-auto px-4 py-8">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div>
                    <h3 class="text-xl font-bold mb-4 text-primary">PSAU GAD</h3>
                    <p class="text-gray-300">Gender and Development Information System</p>
                    <p class="text-gray-300 mt-2">Pampanga State Agricultural University</p>
                </div>
                <div>
                    <h4 class="text-lg font-semibold mb-4">Quick Links</h4>
                    <ul class="space-y-2">
                        <li><a href="<?php echo BASE_URL; ?>/index.php" class="text-gray-300 hover:text-primary">Home</a></li>
                        <li><a href="<?php echo BASE_URL; ?>/activities.php" class="text-gray-300 hover:text-primary">Activities</a></li>
                        <li><a href="<?php echo BASE_URL; ?>/contact.php" class="text-gray-300 hover:text-primary">Contact</a></li>
                    </ul>
                </div>
                <div>
                    <h4 class="text-lg font-semibold mb-4">Contact Information</h4>
                    <ul class="space-y-2 text-gray-300">
                        <li><i class="fas fa-envelope mr-2"></i> <?php echo SITE_EMAIL; ?></li>
                        <li><i class="fas fa-phone mr-2"></i> (045) 123-4567</li>
                        <li><i class="fas fa-map-marker-alt mr-2"></i> Magalang, Pampanga</li>
                    </ul>
                </div>
            </div>
            <div class="border-t border-gray-700 mt-8 pt-6 text-center text-gray-400">
                <p>&copy; <?php echo date('Y'); ?> Pampanga State Agricultural University. All rights reserved.</p>
            </div>
        </div>
    </footer>
    
    <!-- jQuery (for some plugins) -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    
    <!-- Custom JavaScript -->
    <script>
        // Auto-hide flash messages after 5 seconds
        setTimeout(function() {
            const alerts = document.querySelectorAll('[role="alert"]');
            alerts.forEach(alert => {
                alert.style.opacity = '0';
                setTimeout(() => alert.remove(), 300);
            });
        }, 5000);
        
        // Confirm delete actions
        function confirmDelete(message = 'Are you sure you want to delete this?') {
            return confirm(message);
        }
        
        // Show loading spinner
        function showLoading() {
            const loader = document.createElement('div');
            loader.id = 'loading-overlay';
            loader.className = 'fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50';
            loader.innerHTML = '<div class="spinner"></div>';
            document.body.appendChild(loader);
        }
        
        // Hide loading spinner
        function hideLoading() {
            const loader = document.getElementById('loading-overlay');
            if (loader) {
                loader.remove();
            }
        }
        
        // Format date
        function formatDate(dateString) {
            const options = { year: 'numeric', month: 'long', day: 'numeric' };
            return new Date(dateString).toLocaleDateString('en-US', options);
        }
        
        // Format time
        function formatTime(timeString) {
            const options = { hour: 'numeric', minute: '2-digit', hour12: true };
            return new Date('2000-01-01 ' + timeString).toLocaleTimeString('en-US', options);
        }
    </script>
    
    <?php if (isset($additionalJS)): ?>
        <?php echo $additionalJS; ?>
    <?php endif; ?>
</body>
</html>

