<?php
require_once '../config/config.php';
requireRole('employee');

$pageTitle = 'My Profile - PSAU GAD';
$db = getDB();
$userId = getCurrentUserId();

// Get profile
$stmt = $db->prepare("SELECT ep.*, u.email FROM employee_profiles ep JOIN users u ON ep.user_id = u.user_id WHERE ep.user_id = ?");
$stmt->execute([$userId]);
$profile = $stmt->fetch();

// Handle profile update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_profile'])) {
    $firstName = trim($_POST['first_name']);
    $lastName = trim($_POST['last_name']);
    $middleName = trim($_POST['middle_name']);
    $gender = $_POST['gender'];
    $category = $_POST['category'];
    $contactNumber = trim($_POST['contact_number']);
    
    $stmt = $db->prepare("UPDATE employee_profiles SET first_name = ?, last_name = ?, middle_name = ?, gender = ?, category = ?, contact_number = ? WHERE user_id = ?");
    if ($stmt->execute([$firstName, $lastName, $middleName, $gender, $category, $contactNumber, $userId])) {
        $_SESSION['success'] = 'Profile updated successfully!';
        header('Location: profile.php');
        exit;
    }
}

// Handle password change
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['change_password'])) {
    $currentPassword = $_POST['current_password'];
    $newPassword = $_POST['new_password'];
    $confirmPassword = $_POST['confirm_password'];
    
    $stmt = $db->prepare("SELECT password FROM users WHERE user_id = ?");
    $stmt->execute([$userId]);
    $user = $stmt->fetch();
    
    if (password_verify($currentPassword, $user['password'])) {
        if ($newPassword === $confirmPassword) {
            if (strlen($newPassword) >= 8) {
                $hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);
                $stmt = $db->prepare("UPDATE users SET password = ? WHERE user_id = ?");
                if ($stmt->execute([$hashedPassword, $userId])) {
                    $_SESSION['success'] = 'Password changed successfully!';
                    header('Location: profile.php');
                    exit;
                }
            } else {
                $_SESSION['error'] = 'Password must be at least 8 characters long.';
            }
        } else {
            $_SESSION['error'] = 'New passwords do not match.';
        }
    } else {
        $_SESSION['error'] = 'Current password is incorrect.';
    }
}

include '../includes/header.php';
include '../includes/navbar.php';
?>

<div class="min-h-screen bg-gray-50 py-8">
    <div class="container mx-auto px-4">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-gray-900 mb-2"><i class="fas fa-user-circle text-employee mr-2"></i>My Profile</h1>
            <p class="text-gray-600">Manage your personal information and account settings</p>
        </div>

        <?php if (isset($_SESSION['success'])): ?>
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg mb-6">
                <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
            </div>
        <?php endif; ?>

        <?php if (isset($_SESSION['error'])): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg mb-6">
                <?php echo $_SESSION['error']; unset($_SESSION['error']); ?>
            </div>
        <?php endif; ?>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Profile Card -->
            <div class="lg:col-span-1">
                <div class="bg-white rounded-xl shadow-lg p-6 text-center">
                    <div class="bg-employee bg-opacity-10 w-24 h-24 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-user text-employee text-4xl"></i>
                    </div>
                    <h2 class="text-2xl font-bold text-gray-900 mb-1"><?php echo htmlspecialchars($profile['first_name'] . ' ' . $profile['last_name']); ?></h2>
                    <p class="text-gray-600 mb-4"><?php echo htmlspecialchars($profile['email']); ?></p>
                    <div class="space-y-2">
                        <div class="bg-gray-50 rounded-lg p-3">
                            <p class="text-xs text-gray-500">Category</p>
                            <p class="font-semibold text-gray-900"><?php echo htmlspecialchars($profile['category']); ?></p>
                        </div>
                        <div class="bg-gray-50 rounded-lg p-3">
                            <p class="text-xs text-gray-500">Gender</p>
                            <p class="font-semibold text-gray-900"><?php echo htmlspecialchars($profile['gender']); ?></p>
                        </div>
                        <?php if ($profile['contact_number']): ?>
                            <div class="bg-gray-50 rounded-lg p-3">
                                <p class="text-xs text-gray-500">Contact Number</p>
                                <p class="font-semibold text-gray-900"><?php echo htmlspecialchars($profile['contact_number']); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Forms -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Update Profile Form -->
                <div class="bg-white rounded-xl shadow-lg p-6">
                    <h3 class="text-xl font-bold text-gray-900 mb-6"><i class="fas fa-edit text-employee mr-2"></i>Update Profile</h3>
                    <form method="POST">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">First Name *</label>
                                <input type="text" name="first_name" value="<?php echo htmlspecialchars($profile['first_name']); ?>" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-employee focus:border-transparent">
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Last Name *</label>
                                <input type="text" name="last_name" value="<?php echo htmlspecialchars($profile['last_name']); ?>" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-employee focus:border-transparent">
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Middle Name</label>
                                <input type="text" name="middle_name" value="<?php echo htmlspecialchars($profile['middle_name']); ?>" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-employee focus:border-transparent">
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Gender *</label>
                                <select name="gender" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-employee focus:border-transparent">
                                    <option value="Male" <?php echo $profile['gender'] === 'Male' ? 'selected' : ''; ?>>Male</option>
                                    <option value="Female" <?php echo $profile['gender'] === 'Female' ? 'selected' : ''; ?>>Female</option>
                                </select>
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Category *</label>
                                <select name="category" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-employee focus:border-transparent">
                                    <option value="Faculty" <?php echo $profile['category'] === 'Faculty' ? 'selected' : ''; ?>>Faculty</option>
                                    <option value="Non-Teaching" <?php echo $profile['category'] === 'Non-Teaching' ? 'selected' : ''; ?>>Non-Teaching</option>
                                </select>
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Contact Number</label>
                                <input type="text" name="contact_number" value="<?php echo htmlspecialchars($profile['contact_number']); ?>" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-employee focus:border-transparent">
                            </div>
                        </div>
                        <div class="mt-6">
                            <button type="submit" name="update_profile" class="bg-employee text-white px-6 py-3 rounded-lg hover:bg-green-700 transition font-semibold">
                                <i class="fas fa-save mr-2"></i>Save Changes
                            </button>
                        </div>
                    </form>
                </div>

                <!-- Change Password Form -->
                <div class="bg-white rounded-xl shadow-lg p-6">
                    <h3 class="text-xl font-bold text-gray-900 mb-6"><i class="fas fa-lock text-employee mr-2"></i>Change Password</h3>
                    <form method="POST">
                        <div class="space-y-4">
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Current Password *</label>
                                <input type="password" name="current_password" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-employee focus:border-transparent">
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">New Password *</label>
                                <input type="password" name="new_password" required minlength="8" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-employee focus:border-transparent">
                                <p class="text-xs text-gray-500 mt-1">Minimum 8 characters</p>
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Confirm New Password *</label>
                                <input type="password" name="confirm_password" required minlength="8" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-employee focus:border-transparent">
                            </div>
                        </div>
                        <div class="mt-6">
                            <button type="submit" name="change_password" class="bg-employee text-white px-6 py-3 rounded-lg hover:bg-green-700 transition font-semibold">
                                <i class="fas fa-key mr-2"></i>Change Password
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>

