<?php
require_once '../config/config.php';
requireRole('employee');

$pageTitle = 'Post-Test Result - Employee - PSAU GAD';
$db = getDB();

// Get response ID
$responseId = isset($_GET['response_id']) ? (int)$_GET['response_id'] : 0;

if (!$responseId) {
    $_SESSION['error'] = 'Invalid response ID.';
    header('Location: my-activities.php');
    exit;
}

// Get response details
$stmt = $db->prepare("
    SELECT 
        ptr.*,
        pt.title as test_title,
        pt.passing_score,
        a.title as activity_title,
        a.activity_id
    FROM post_test_responses ptr
    JOIN post_tests pt ON ptr.test_id = pt.test_id
    JOIN activities a ON ptr.activity_id = a.activity_id
    WHERE ptr.response_id = ? AND ptr.user_id = ?
");
$stmt->execute([$responseId, getCurrentUserId()]);
$response = $stmt->fetch();

if (!$response) {
    $_SESSION['error'] = 'Response not found.';
    header('Location: my-activities.php');
    exit;
}

// Get answers with questions
$stmt = $db->prepare("
    SELECT 
        ta.*,
        tq.question_text,
        tq.question_type,
        tq.option_a,
        tq.option_b,
        tq.option_c,
        tq.option_d,
        tq.correct_answer,
        tq.points
    FROM test_answers ta
    JOIN test_questions tq ON ta.question_id = tq.question_id
    WHERE ta.response_id = ? AND ta.test_type = 'post_test'
    ORDER BY tq.order_num
");
$stmt->execute([$responseId]);
$answers = $stmt->fetchAll();

include '../includes/header.php';
include '../includes/navbar.php';
?>

<div class="min-h-screen bg-gray-50 py-8">
    <div class="container mx-auto px-4 max-w-4xl">
        <!-- Result Header -->
        <div class="bg-white rounded-xl shadow-lg overflow-hidden mb-8">
            <div class="bg-employee text-white px-8 py-6">
                <h1 class="text-2xl font-bold mb-2">
                    <i class="fas fa-chart-bar mr-2"></i>Post-Test Results
                </h1>
                <p class="text-employee-light"><?php echo htmlspecialchars($response['test_title']); ?></p>
                <p class="text-sm text-employee-light"><?php echo htmlspecialchars($response['activity_title']); ?></p>
            </div>
            
            <!-- Score Summary -->
            <div class="p-8">
                <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
                    <div class="text-center p-4 bg-blue-50 rounded-lg">
                        <p class="text-3xl font-bold text-blue-600"><?php echo number_format($response['score'], 1); ?></p>
                        <p class="text-sm text-gray-600">Score</p>
                    </div>
                    <div class="text-center p-4 bg-purple-50 rounded-lg">
                        <p class="text-3xl font-bold text-purple-600"><?php echo $response['total_points']; ?></p>
                        <p class="text-sm text-gray-600">Total Points</p>
                    </div>
                    <div class="text-center p-4 bg-yellow-50 rounded-lg">
                        <p class="text-3xl font-bold text-yellow-600"><?php echo number_format($response['percentage'], 1); ?>%</p>
                        <p class="text-sm text-gray-600">Percentage</p>
                    </div>
                    <div class="text-center p-4 <?php echo $response['passed'] ? 'bg-green-50' : 'bg-red-50'; ?> rounded-lg">
                        <p class="text-3xl font-bold <?php echo $response['passed'] ? 'text-green-600' : 'text-red-600'; ?>">
                            <?php echo $response['passed'] ? 'PASSED' : 'FAILED'; ?>
                        </p>
                        <p class="text-sm text-gray-600">Result</p>
                    </div>
                </div>
                
                <?php if ($response['passed']): ?>
                    <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 rounded">
                        <p class="font-semibold"><i class="fas fa-check-circle mr-2"></i>Congratulations!</p>
                        <p>You passed the post-test with <?php echo number_format($response['percentage'], 1); ?>%. The passing score is <?php echo $response['passing_score']; ?>%.</p>
                    </div>
                <?php else: ?>
                    <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 rounded">
                        <p class="font-semibold"><i class="fas fa-times-circle mr-2"></i>Not Passed</p>
                        <p>You scored <?php echo number_format($response['percentage'], 1); ?>%. The passing score is <?php echo $response['passing_score']; ?>%.</p>
                    </div>
                <?php endif; ?>
                
                <div class="mt-6 text-sm text-gray-600">
                    <p><i class="fas fa-clock mr-2"></i>Submitted: <?php echo date('F j, Y g:i A', strtotime($response['submitted_at'])); ?></p>
                    <?php if ($response['time_taken']): ?>
                        <p><i class="fas fa-stopwatch mr-2"></i>Time Taken: <?php echo floor($response['time_taken'] / 60); ?> minutes <?php echo $response['time_taken'] % 60; ?> seconds</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <!-- Answers Review -->
        <div class="bg-white rounded-xl shadow-lg p-8">
            <h2 class="text-xl font-bold text-gray-900 mb-6">
                <i class="fas fa-list mr-2"></i>Answer Review
            </h2>
            
            <div class="space-y-6">
                <?php foreach ($answers as $index => $answer): ?>
                    <div class="border border-gray-200 rounded-lg p-6 <?php echo $answer['is_correct'] ? 'bg-green-50' : 'bg-red-50'; ?>">
                        <div class="flex items-start justify-between mb-4">
                            <div class="flex-1">
                                <div class="flex items-center mb-2">
                                    <span class="bg-gray-700 text-white px-3 py-1 rounded-lg font-bold mr-3">
                                        Q<?php echo $index + 1; ?>
                                    </span>
                                    <?php if ($answer['is_correct']): ?>
                                        <span class="px-3 py-1 rounded-full text-xs font-semibold bg-green-100 text-green-800">
                                            <i class="fas fa-check mr-1"></i>Correct
                                        </span>
                                    <?php else: ?>
                                        <span class="px-3 py-1 rounded-full text-xs font-semibold bg-red-100 text-red-800">
                                            <i class="fas fa-times mr-1"></i>Incorrect
                                        </span>
                                    <?php endif; ?>
                                    <span class="ml-2 text-sm text-gray-600">
                                        <?php echo $answer['points_earned']; ?> / <?php echo $answer['points']; ?> points
                                    </span>
                                </div>
                                <p class="text-lg font-medium text-gray-900">
                                    <?php echo htmlspecialchars($answer['question_text']); ?>
                                </p>
                            </div>
                        </div>
                        
                        <?php if ($answer['question_type'] === 'multiple_choice'): ?>
                            <div class="ml-12 space-y-2">
                                <div class="p-3 rounded-lg <?php echo $answer['answer_text'] === 'A' ? ($answer['is_correct'] ? 'bg-green-200 border-2 border-green-500' : 'bg-red-200 border-2 border-red-500') : ($answer['correct_answer'] === 'A' ? 'bg-green-100' : 'bg-white'); ?>">
                                    <strong>A.</strong> <?php echo htmlspecialchars($answer['option_a']); ?>
                                    <?php if ($answer['correct_answer'] === 'A'): ?>
                                        <i class="fas fa-check-circle text-green-600 ml-2"></i>
                                    <?php endif; ?>
                                </div>
                                <div class="p-3 rounded-lg <?php echo $answer['answer_text'] === 'B' ? ($answer['is_correct'] ? 'bg-green-200 border-2 border-green-500' : 'bg-red-200 border-2 border-red-500') : ($answer['correct_answer'] === 'B' ? 'bg-green-100' : 'bg-white'); ?>">
                                    <strong>B.</strong> <?php echo htmlspecialchars($answer['option_b']); ?>
                                    <?php if ($answer['correct_answer'] === 'B'): ?>
                                        <i class="fas fa-check-circle text-green-600 ml-2"></i>
                                    <?php endif; ?>
                                </div>
                                <div class="p-3 rounded-lg <?php echo $answer['answer_text'] === 'C' ? ($answer['is_correct'] ? 'bg-green-200 border-2 border-green-500' : 'bg-red-200 border-2 border-red-500') : ($answer['correct_answer'] === 'C' ? 'bg-green-100' : 'bg-white'); ?>">
                                    <strong>C.</strong> <?php echo htmlspecialchars($answer['option_c']); ?>
                                    <?php if ($answer['correct_answer'] === 'C'): ?>
                                        <i class="fas fa-check-circle text-green-600 ml-2"></i>
                                    <?php endif; ?>
                                </div>
                                <div class="p-3 rounded-lg <?php echo $answer['answer_text'] === 'D' ? ($answer['is_correct'] ? 'bg-green-200 border-2 border-green-500' : 'bg-red-200 border-2 border-red-500') : ($answer['correct_answer'] === 'D' ? 'bg-green-100' : 'bg-white'); ?>">
                                    <strong>D.</strong> <?php echo htmlspecialchars($answer['option_d']); ?>
                                    <?php if ($answer['correct_answer'] === 'D'): ?>
                                        <i class="fas fa-check-circle text-green-600 ml-2"></i>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php elseif ($answer['question_type'] === 'true_false'): ?>
                            <div class="ml-12 space-y-2">
                                <div class="p-3 rounded-lg <?php echo $answer['answer_text'] === 'TRUE' ? ($answer['is_correct'] ? 'bg-green-200 border-2 border-green-500' : 'bg-red-200 border-2 border-red-500') : ($answer['correct_answer'] === 'TRUE' ? 'bg-green-100' : 'bg-white'); ?>">
                                    <strong>TRUE</strong>
                                    <?php if ($answer['correct_answer'] === 'TRUE'): ?>
                                        <i class="fas fa-check-circle text-green-600 ml-2"></i>
                                    <?php endif; ?>
                                </div>
                                <div class="p-3 rounded-lg <?php echo $answer['answer_text'] === 'FALSE' ? ($answer['is_correct'] ? 'bg-green-200 border-2 border-green-500' : 'bg-red-200 border-2 border-red-500') : ($answer['correct_answer'] === 'FALSE' ? 'bg-green-100' : 'bg-white'); ?>">
                                    <strong>FALSE</strong>
                                    <?php if ($answer['correct_answer'] === 'FALSE'): ?>
                                        <i class="fas fa-check-circle text-green-600 ml-2"></i>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php elseif ($answer['question_type'] === 'essay'): ?>
                            <div class="ml-12">
                                <p class="text-sm text-gray-600 mb-2">Your Answer:</p>
                                <div class="p-4 bg-white rounded-lg border border-gray-300">
                                    <?php echo nl2br(htmlspecialchars($answer['answer_text'])); ?>
                                </div>
                                <p class="text-sm text-blue-600 mt-2"><i class="fas fa-info-circle mr-1"></i>Essay answers require manual grading</p>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        
        <!-- Actions -->
        <div class="mt-8 flex justify-center">
            <a href="my-activities.php" class="bg-employee text-white px-8 py-3 rounded-lg hover:bg-employee-dark transition font-semibold">
                <i class="fas fa-arrow-left mr-2"></i>Back to My Activities
            </a>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>

