<?php
require_once '../config/config.php';
requireRole('employee');

$pageTitle = 'My Activities - PSAU GAD';
$db = getDB();
$userId = getCurrentUserId();

// Get my registrations with activity details
$stmt = $db->prepare("
    SELECT
        ar.*,
        a.title,
        a.description,
        a.activity_date,
        a.start_time,
        a.end_time,
        a.venue,
        a.category,
        aa.status as attendance_status,
        aa.check_in_time,
        pt.test_id as pre_test_id,
        pt.title as pre_test_title,
        ptr.response_id as pre_test_taken,
        ptr.passed as pre_test_passed,
        pot.test_id as post_test_id,
        pot.title as post_test_title,
        potr.response_id as post_test_taken,
        potr.passed as post_test_passed,
        ef.form_id as evaluation_form_id,
        ef.title as evaluation_title,
        er.response_id as evaluation_submitted
    FROM activity_registrations ar
    JOIN activities a ON ar.activity_id = a.activity_id
    LEFT JOIN activity_attendance aa ON ar.registration_id = aa.registration_id
    LEFT JOIN pre_tests pt ON a.activity_id = pt.activity_id AND pt.is_active = 1
    LEFT JOIN pre_test_responses ptr ON pt.test_id = ptr.test_id AND ptr.user_id = ?
    LEFT JOIN post_tests pot ON a.activity_id = pot.activity_id AND pot.is_active = 1
    LEFT JOIN post_test_responses potr ON pot.test_id = potr.test_id AND potr.user_id = ?
    LEFT JOIN evaluation_forms ef ON a.activity_id = ef.activity_id AND ef.is_active = 1
    LEFT JOIN evaluation_responses er ON ef.form_id = er.form_id AND er.user_id = ?
    WHERE ar.user_id = ?
    ORDER BY a.activity_date DESC
");
$stmt->execute([$userId, $userId, $userId, $userId]);
$registrations = $stmt->fetchAll();

include '../includes/header.php';
include '../includes/navbar.php';
?>

<div class="min-h-screen bg-gray-50 py-8">
    <div class="container mx-auto px-4">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-gray-900 mb-2"><i class="fas fa-clipboard-list text-employee mr-2"></i>My Activities</h1>
            <p class="text-gray-600">View all your activity registrations and attendance</p>
        </div>

        <?php if (empty($registrations)): ?>
            <div class="bg-white rounded-xl shadow-lg p-12 text-center">
                <i class="fas fa-clipboard text-gray-300 text-6xl mb-4"></i>
                <h3 class="text-xl font-bold text-gray-900 mb-2">No Registrations Yet</h3>
                <p class="text-gray-600 mb-6">You haven't registered for any activities yet.</p>
                <a href="activities.php" class="inline-block bg-employee text-white px-6 py-3 rounded-lg hover:bg-green-700 transition font-semibold">
                    <i class="fas fa-calendar-plus mr-2"></i>Browse Activities
                </a>
            </div>
        <?php else: ?>
            <div class="space-y-6">
                <?php foreach ($registrations as $reg): ?>
                    <div class="bg-white rounded-xl shadow-lg overflow-hidden">
                        <div class="flex flex-col md:flex-row">
                            <!-- Left Side - Activity Info -->
                            <div class="flex-1 p-6">
                                <div class="flex items-start justify-between mb-4">
                                    <div class="flex-1">
                                        <h3 class="text-xl font-bold text-gray-900 mb-2"><?php echo htmlspecialchars($reg['title']); ?></h3>
                                        <div class="flex flex-wrap gap-2 mb-3">
                                            <span class="text-xs bg-employee bg-opacity-10 text-employee px-2 py-1 rounded font-semibold"><?php echo htmlspecialchars($reg['category']); ?></span>
                                            <span class="text-xs px-2 py-1 rounded font-semibold <?php 
                                                echo $reg['status'] === 'approved' ? 'bg-green-100 text-green-700' : 
                                                     ($reg['status'] === 'rejected' ? 'bg-red-100 text-red-700' : 
                                                     'bg-yellow-100 text-yellow-700'); 
                                            ?>">
                                                <?php echo ucfirst($reg['status']); ?>
                                            </span>
                                            <?php if ($reg['attendance_status']): ?>
                                                <span class="text-xs px-2 py-1 rounded font-semibold <?php 
                                                    echo $reg['attendance_status'] === 'present' ? 'bg-blue-100 text-blue-700' : 'bg-orange-100 text-orange-700'; 
                                                ?>">
                                                    <i class="fas fa-check mr-1"></i><?php echo ucfirst($reg['attendance_status']); ?>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                                    <div class="flex items-center text-sm text-gray-600">
                                        <i class="fas fa-calendar w-6 text-employee"></i>
                                        <span><?php echo formatDate($reg['activity_date']); ?></span>
                                    </div>
                                    <div class="flex items-center text-sm text-gray-600">
                                        <i class="fas fa-clock w-6 text-employee"></i>
                                        <span><?php echo formatTime($reg['start_time']); ?> - <?php echo formatTime($reg['end_time']); ?></span>
                                    </div>
                                    <div class="flex items-center text-sm text-gray-600">
                                        <i class="fas fa-map-marker-alt w-6 text-employee"></i>
                                        <span><?php echo htmlspecialchars($reg['venue']); ?></span>
                                    </div>
                                    <div class="flex items-center text-sm text-gray-600">
                                        <i class="fas fa-calendar-check w-6 text-employee"></i>
                                        <span>Registered: <?php echo formatDate($reg['registration_date']); ?></span>
                                    </div>
                                </div>

                                <?php if ($reg['attendance_status'] && $reg['check_in_time']): ?>
                                    <div class="bg-blue-50 border border-blue-200 rounded-lg p-3 text-sm">
                                        <i class="fas fa-info-circle text-blue-600 mr-2"></i>
                                        <span class="text-blue-900">Attended on <?php echo date('M j, Y \a\t g:i A', strtotime($reg['check_in_time'])); ?></span>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <!-- Right Side - Actions -->
                            <div class="bg-gray-50 p-6 md:w-64 flex flex-col justify-center space-y-3">
                                <a href="activity-details.php?id=<?php echo $reg['activity_id']; ?>" class="block w-full bg-gray-200 text-gray-700 text-center px-4 py-2 rounded-lg hover:bg-gray-300 transition font-semibold text-sm">
                                    <i class="fas fa-eye mr-2"></i>View Details
                                </a>

                                <?php if ($reg['status'] === 'approved'): ?>
                                    <!-- Pre-Test -->
                                    <?php if ($reg['pre_test_id']): ?>
                                        <?php if ($reg['pre_test_taken']): ?>
                                            <a href="pre-test-result.php?response_id=<?php echo $reg['pre_test_taken']; ?>" class="block w-full bg-blue-500 text-white text-center px-4 py-2 rounded-lg hover:bg-blue-600 transition font-semibold text-sm">
                                                <i class="fas fa-check-circle mr-2"></i>Pre-Test: <?php echo $reg['pre_test_passed'] ? 'Passed' : 'Taken'; ?>
                                            </a>
                                        <?php else: ?>
                                            <a href="pre-test.php?activity_id=<?php echo $reg['activity_id']; ?>" class="block w-full bg-purple-500 text-white text-center px-4 py-2 rounded-lg hover:bg-purple-600 transition font-semibold text-sm animate-pulse">
                                                <i class="fas fa-file-alt mr-2"></i>Take Pre-Test
                                            </a>
                                        <?php endif; ?>
                                    <?php endif; ?>

                                    <!-- QR Code -->
                                    <?php if ($reg['qr_code']): ?>
                                        <a href="qr-code.php?id=<?php echo $reg['registration_id']; ?>" class="block w-full bg-employee text-white text-center px-4 py-2 rounded-lg hover:bg-green-700 transition font-semibold text-sm">
                                            <i class="fas fa-qrcode mr-2"></i>View QR Code
                                        </a>
                                    <?php endif; ?>

                                    <!-- Post-Test (only show if attended) -->
                                    <?php if ($reg['post_test_id'] && $reg['attendance_status']): ?>
                                        <?php if ($reg['post_test_taken']): ?>
                                            <a href="post-test-result.php?response_id=<?php echo $reg['post_test_taken']; ?>" class="block w-full bg-indigo-500 text-white text-center px-4 py-2 rounded-lg hover:bg-indigo-600 transition font-semibold text-sm">
                                                <i class="fas fa-check-circle mr-2"></i>Post-Test: <?php echo $reg['post_test_passed'] ? 'Passed' : 'Taken'; ?>
                                            </a>
                                        <?php else: ?>
                                            <a href="post-test.php?activity_id=<?php echo $reg['activity_id']; ?>" class="block w-full bg-orange-500 text-white text-center px-4 py-2 rounded-lg hover:bg-orange-600 transition font-semibold text-sm animate-pulse">
                                                <i class="fas fa-file-alt mr-2"></i>Take Post-Test
                                            </a>
                                        <?php endif; ?>
                                    <?php endif; ?>

                                    <!-- Evaluation (only show if attended) -->
                                    <?php if ($reg['evaluation_form_id'] && $reg['attendance_status']): ?>
                                        <?php if ($reg['evaluation_submitted']): ?>
                                            <div class="block w-full bg-green-100 text-green-800 text-center px-4 py-2 rounded-lg font-semibold text-sm border-2 border-green-500">
                                                <i class="fas fa-check-double mr-2"></i>Evaluation Submitted
                                            </div>
                                        <?php else: ?>
                                            <a href="evaluation.php?activity_id=<?php echo $reg['activity_id']; ?>" class="block w-full bg-pink-500 text-white text-center px-4 py-2 rounded-lg hover:bg-pink-600 transition font-semibold text-sm animate-pulse">
                                                <i class="fas fa-star mr-2"></i>Submit Evaluation
                                            </a>
                                        <?php endif; ?>
                                    <?php endif; ?>

                                    <!-- Certificate (only if attended and evaluation submitted) -->
                                    <?php if ($reg['attendance_status'] && in_array($reg['attendance_status'], ['present', 'late'])): ?>
                                        <?php
                                        // Check if evaluation is required and submitted
                                        $canGetCertificate = true;
                                        if ($reg['evaluation_form_id'] && !$reg['evaluation_submitted']) {
                                            $canGetCertificate = false;
                                        }
                                        ?>
                                        <?php if ($canGetCertificate): ?>
                                            <a href="certificate.php?id=<?php echo $reg['registration_id']; ?>"
                                               class="block w-full bg-gradient-to-r from-yellow-500 to-orange-500 text-white text-center px-4 py-2 rounded-lg hover:from-yellow-600 hover:to-orange-600 transition font-semibold text-sm shadow-lg">
                                                <i class="fas fa-certificate mr-2"></i>View Certificate
                                            </a>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <?php if ($reg['status'] === 'rejected'): ?>
                                    <div class="text-xs text-red-600 text-center">
                                        <i class="fas fa-exclamation-circle mr-1"></i>
                                        Registration was not approved
                                    </div>
                                <?php elseif ($reg['status'] === 'pending'): ?>
                                    <div class="text-xs text-yellow-600 text-center">
                                        <i class="fas fa-clock mr-1"></i>
                                        Waiting for approval
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include '../includes/footer.php'; ?>

