<?php
require_once '../config/config.php';
requireRole('employee');

$pageTitle = 'Dashboard - PSAU GAD';
$db = getDB();
$userId = getCurrentUserId();

// Get employee profile
$stmt = $db->prepare("SELECT ep.*, u.email FROM employee_profiles ep JOIN users u ON ep.user_id = u.user_id WHERE ep.user_id = ?");
$stmt->execute([$userId]);
$profile = $stmt->fetch();

// Get upcoming activities
$stmt = $db->query("SELECT * FROM activities WHERE is_active = 1 AND activity_date >= CURDATE() ORDER BY activity_date ASC LIMIT 5");
$upcomingActivities = $stmt->fetchAll();

// Get my registrations
$stmt = $db->prepare("SELECT ar.*, a.title, a.activity_date, a.start_time, a.venue FROM activity_registrations ar JOIN activities a ON ar.activity_id = a.activity_id WHERE ar.user_id = ? ORDER BY a.activity_date DESC LIMIT 5");
$stmt->execute([$userId]);
$myRegistrations = $stmt->fetchAll();

// Get statistics
$stmt = $db->prepare("SELECT COUNT(*) as count FROM activity_registrations WHERE user_id = ?");
$stmt->execute([$userId]);
$totalRegistrations = $stmt->fetch()['count'];

$stmt = $db->prepare("SELECT COUNT(*) as count FROM activity_registrations WHERE user_id = ? AND status = 'approved'");
$stmt->execute([$userId]);
$approvedRegistrations = $stmt->fetch()['count'];

$stmt = $db->prepare("SELECT COUNT(*) as count FROM certificates WHERE user_id = ?");
$stmt->execute([$userId]);
$totalCertificates = $stmt->fetch()['count'];

$stmt = $db->prepare("SELECT COUNT(*) as count FROM activity_attendance aa JOIN activity_registrations ar ON aa.registration_id = ar.registration_id WHERE ar.user_id = ?");
$stmt->execute([$userId]);
$totalAttendance = $stmt->fetch()['count'];

include '../includes/header.php';
include '../includes/navbar.php';
?>

<div class="min-h-screen bg-gray-50 py-8">
    <div class="container mx-auto px-4">
        <!-- Welcome Banner -->
        <div class="bg-gradient-to-r from-employee to-green-600 rounded-xl shadow-lg p-8 mb-8 text-white">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold mb-2">Welcome back, <?php echo htmlspecialchars($profile['first_name']); ?>! 👋</h1>
                    <p class="text-green-100"><?php echo htmlspecialchars($profile['category']); ?> • <?php echo htmlspecialchars($profile['gender']); ?></p>
                </div>
                <div class="hidden md:block"><i class="fas fa-user-circle text-8xl opacity-20"></i></div>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
            <div class="bg-white rounded-xl shadow-lg p-6 border-l-4 border-employee">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-gray-500 text-sm font-semibold">Total Registrations</p>
                        <h3 class="text-3xl font-bold text-gray-900 mt-2"><?php echo $totalRegistrations; ?></h3>
                    </div>
                    <div class="bg-employee bg-opacity-10 p-4 rounded-full"><i class="fas fa-clipboard-list text-employee text-2xl"></i></div>
                </div>
            </div>
            <div class="bg-white rounded-xl shadow-lg p-6 border-l-4 border-green-500">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-gray-500 text-sm font-semibold">Approved</p>
                        <h3 class="text-3xl font-bold text-gray-900 mt-2"><?php echo $approvedRegistrations; ?></h3>
                    </div>
                    <div class="bg-green-100 p-4 rounded-full"><i class="fas fa-check-circle text-green-500 text-2xl"></i></div>
                </div>
            </div>
            <div class="bg-white rounded-xl shadow-lg p-6 border-l-4 border-blue-500">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-gray-500 text-sm font-semibold">Attended</p>
                        <h3 class="text-3xl font-bold text-gray-900 mt-2"><?php echo $totalAttendance; ?></h3>
                    </div>
                    <div class="bg-blue-100 p-4 rounded-full"><i class="fas fa-user-check text-blue-500 text-2xl"></i></div>
                </div>
            </div>
            <div class="bg-white rounded-xl shadow-lg p-6 border-l-4 border-yellow-500">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-gray-500 text-sm font-semibold">Certificates</p>
                        <h3 class="text-3xl font-bold text-gray-900 mt-2"><?php echo $totalCertificates; ?></h3>
                    </div>
                    <div class="bg-yellow-100 p-4 rounded-full"><i class="fas fa-certificate text-yellow-500 text-2xl"></i></div>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <!-- Upcoming Activities -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <div class="flex items-center justify-between mb-6">
                    <h2 class="text-xl font-bold text-gray-900"><i class="fas fa-calendar-alt text-employee mr-2"></i>Upcoming Activities</h2>
                    <a href="activities.php" class="text-employee hover:text-green-700 text-sm font-semibold">View All <i class="fas fa-arrow-right ml-1"></i></a>
                </div>
                <?php if (empty($upcomingActivities)): ?>
                    <p class="text-center text-gray-500 py-8">No upcoming activities</p>
                <?php else: ?>
                    <div class="space-y-4">
                        <?php foreach ($upcomingActivities as $activity): ?>
                            <div class="border border-gray-200 rounded-lg p-4 hover:border-employee transition">
                                <h4 class="font-semibold text-gray-900 mb-2"><?php echo htmlspecialchars($activity['title']); ?></h4>
                                <div class="flex items-center text-sm text-gray-600 space-x-4">
                                    <span><i class="fas fa-calendar text-employee mr-1"></i><?php echo formatDate($activity['activity_date']); ?></span>
                                    <span><i class="fas fa-clock text-employee mr-1"></i><?php echo formatTime($activity['start_time']); ?></span>
                                </div>
                                <div class="mt-2"><span class="text-xs bg-employee bg-opacity-10 text-employee px-2 py-1 rounded"><?php echo htmlspecialchars($activity['category']); ?></span></div>
                                <div class="mt-3"><a href="activity-details.php?id=<?php echo $activity['activity_id']; ?>" class="text-employee hover:text-green-700 text-sm font-semibold">View Details <i class="fas fa-arrow-right ml-1"></i></a></div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>

            <!-- My Registrations -->
            <div class="bg-white rounded-xl shadow-lg p-6">
                <div class="flex items-center justify-between mb-6">
                    <h2 class="text-xl font-bold text-gray-900"><i class="fas fa-clipboard-list text-employee mr-2"></i>My Registrations</h2>
                    <a href="my-activities.php" class="text-employee hover:text-green-700 text-sm font-semibold">View All <i class="fas fa-arrow-right ml-1"></i></a>
                </div>
                <?php if (empty($myRegistrations)): ?>
                    <p class="text-center text-gray-500 py-8">No registrations yet</p>
                <?php else: ?>
                    <div class="space-y-3">
                        <?php foreach ($myRegistrations as $reg): ?>
                            <div class="border-l-4 <?php echo $reg['status'] === 'approved' ? 'border-green-500' : ($reg['status'] === 'rejected' ? 'border-red-500' : 'border-yellow-500'); ?> bg-gray-50 p-3 rounded">
                                <div class="flex items-start justify-between">
                                    <div class="flex-1">
                                        <h5 class="font-semibold text-gray-900 text-sm"><?php echo htmlspecialchars($reg['title']); ?></h5>
                                        <p class="text-xs text-gray-600 mt-1"><?php echo formatDate($reg['activity_date']); ?></p>
                                    </div>
                                    <span class="px-2 py-1 rounded-full text-xs font-semibold <?php echo $reg['status'] === 'approved' ? 'bg-green-100 text-green-700' : ($reg['status'] === 'rejected' ? 'bg-red-100 text-red-700' : 'bg-yellow-100 text-yellow-700'); ?>"><?php echo ucfirst($reg['status']); ?></span>
                                </div>
                                <?php if ($reg['status'] === 'approved' && $reg['qr_code']): ?>
                                    <div class="mt-2"><a href="qr-code.php?id=<?php echo $reg['registration_id']; ?>" class="text-employee hover:text-green-700 text-xs font-semibold"><i class="fas fa-qrcode mr-1"></i> View QR Code</a></div>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="mt-8 grid grid-cols-1 md:grid-cols-3 gap-6">
            <a href="activities.php" class="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition group">
                <div class="flex items-center space-x-4">
                    <div class="bg-employee bg-opacity-10 p-4 rounded-full group-hover:bg-employee group-hover:bg-opacity-20 transition"><i class="fas fa-calendar-plus text-employee text-2xl"></i></div>
                    <div><h3 class="font-bold text-gray-900">Browse Activities</h3><p class="text-sm text-gray-600">Find and register for GAD activities</p></div>
                </div>
            </a>
            <a href="certificates.php" class="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition group">
                <div class="flex items-center space-x-4">
                    <div class="bg-yellow-100 p-4 rounded-full group-hover:bg-yellow-200 transition"><i class="fas fa-certificate text-yellow-600 text-2xl"></i></div>
                    <div><h3 class="font-bold text-gray-900">My Certificates</h3><p class="text-sm text-gray-600">View and download certificates</p></div>
                </div>
            </a>
            <a href="profile.php" class="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition group">
                <div class="flex items-center space-x-4">
                    <div class="bg-blue-100 p-4 rounded-full group-hover:bg-blue-200 transition"><i class="fas fa-user-edit text-blue-600 text-2xl"></i></div>
                    <div><h3 class="font-bold text-gray-900">My Profile</h3><p class="text-sm text-gray-600">Update your information</p></div>
                </div>
            </a>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>

