<?php
require_once '../config/config.php';
requireRole('employee');

$pageTitle = 'Activity Details - PSAU GAD';
$db = getDB();
$userId = getCurrentUserId();

$activityId = $_GET['id'] ?? 0;

// Get activity details
$stmt = $db->prepare("SELECT * FROM activities WHERE activity_id = ? AND is_active = 1");
$stmt->execute([$activityId]);
$activity = $stmt->fetch();

if (!$activity) {
    header('Location: activities.php');
    exit;
}

// Check if already registered
$stmt = $db->prepare("SELECT * FROM activity_registrations WHERE activity_id = ? AND user_id = ? AND status != 'rejected'");
$stmt->execute([$activityId, $userId]);
$myRegistration = $stmt->fetch();

// Handle registration
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['register'])) {
    if (!$myRegistration) {
        $stmt = $db->prepare("INSERT INTO activity_registrations (activity_id, user_id, registration_date, status) VALUES (?, ?, NOW(), 'pending')");
        if ($stmt->execute([$activityId, $userId])) {
            $_SESSION['success'] = 'Registration submitted successfully! Please wait for approval.';
            header('Location: activity-details.php?id=' . $activityId);
            exit;
        }
    }
}

include '../includes/header.php';
include '../includes/navbar.php';
?>

<div class="min-h-screen bg-gray-50 py-8">
    <div class="container mx-auto px-4">
        <div class="mb-6">
            <a href="activities.php" class="text-employee hover:text-green-700 font-semibold"><i class="fas fa-arrow-left mr-2"></i>Back to Activities</a>
        </div>

        <?php if (isset($_SESSION['success'])): ?>
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg mb-6">
                <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
            </div>
        <?php endif; ?>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Main Content -->
            <div class="lg:col-span-2">
                <div class="bg-white rounded-xl shadow-lg overflow-hidden">
                    <div class="bg-gradient-to-r from-employee to-green-600 p-8 text-white">
                        <div class="flex items-center justify-between mb-4">
                            <span class="bg-white bg-opacity-20 px-3 py-1 rounded-full text-sm font-semibold"><?php echo htmlspecialchars($activity['category']); ?></span>
                            <span class="bg-white bg-opacity-20 px-3 py-1 rounded-full text-sm font-semibold">Q<?php echo $activity['quarter']; ?> <?php echo $activity['year']; ?></span>
                        </div>
                        <h1 class="text-3xl font-bold mb-2"><?php echo htmlspecialchars($activity['title']); ?></h1>
                        <div class="flex items-center space-x-4 text-green-100">
                            <span><i class="fas fa-calendar mr-2"></i><?php echo formatDate($activity['activity_date']); ?></span>
                            <span><i class="fas fa-clock mr-2"></i><?php echo formatTime($activity['start_time']); ?></span>
                        </div>
                    </div>

                    <div class="p-8">
                        <h2 class="text-xl font-bold text-gray-900 mb-4">Description</h2>
                        <p class="text-gray-700 leading-relaxed mb-6"><?php echo nl2br(htmlspecialchars($activity['description'])); ?></p>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div class="bg-gray-50 p-4 rounded-lg">
                                <h3 class="font-semibold text-gray-900 mb-3">Event Details</h3>
                                <div class="space-y-2 text-sm">
                                    <div class="flex items-center text-gray-700">
                                        <i class="fas fa-map-marker-alt w-6 text-employee"></i>
                                        <span><?php echo htmlspecialchars($activity['venue']); ?></span>
                                    </div>
                                    <div class="flex items-center text-gray-700">
                                        <i class="fas fa-users w-6 text-employee"></i>
                                        <span><?php echo $activity['target_participants']; ?> participants</span>
                                    </div>
                                    <div class="flex items-center text-gray-700">
                                        <i class="fas fa-money-bill-wave w-6 text-employee"></i>
                                        <span>₱<?php echo number_format($activity['budget'], 2); ?></span>
                                    </div>
                                </div>
                            </div>

                            <div class="bg-gray-50 p-4 rounded-lg">
                                <h3 class="font-semibold text-gray-900 mb-3">Schedule</h3>
                                <div class="space-y-2 text-sm">
                                    <div class="flex items-center text-gray-700">
                                        <i class="fas fa-calendar-day w-6 text-employee"></i>
                                        <span><?php echo date('l, F j, Y', strtotime($activity['activity_date'])); ?></span>
                                    </div>
                                    <div class="flex items-center text-gray-700">
                                        <i class="fas fa-clock w-6 text-employee"></i>
                                        <span><?php echo formatTime($activity['start_time']); ?> - <?php echo formatTime($activity['end_time']); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="lg:col-span-1">
                <!-- Registration Card -->
                <div class="bg-white rounded-xl shadow-lg p-6 mb-6">
                    <h3 class="text-xl font-bold text-gray-900 mb-4">Registration</h3>
                    
                    <?php if ($myRegistration): ?>
                        <div class="bg-<?php echo $myRegistration['status'] === 'approved' ? 'green' : ($myRegistration['status'] === 'rejected' ? 'red' : 'yellow'); ?>-50 border border-<?php echo $myRegistration['status'] === 'approved' ? 'green' : ($myRegistration['status'] === 'rejected' ? 'red' : 'yellow'); ?>-200 rounded-lg p-4 mb-4">
                            <div class="flex items-center mb-2">
                                <i class="fas fa-<?php echo $myRegistration['status'] === 'approved' ? 'check-circle' : ($myRegistration['status'] === 'rejected' ? 'times-circle' : 'clock'); ?> text-<?php echo $myRegistration['status'] === 'approved' ? 'green' : ($myRegistration['status'] === 'rejected' ? 'red' : 'yellow'); ?>-600 mr-2"></i>
                                <span class="font-semibold text-<?php echo $myRegistration['status'] === 'approved' ? 'green' : ($myRegistration['status'] === 'rejected' ? 'red' : 'yellow'); ?>-900">
                                    <?php echo ucfirst($myRegistration['status']); ?>
                                </span>
                            </div>
                            <p class="text-sm text-gray-700">
                                <?php if ($myRegistration['status'] === 'approved'): ?>
                                    Your registration has been approved! You will receive your QR code via email.
                                <?php elseif ($myRegistration['status'] === 'rejected'): ?>
                                    Your registration was not approved.
                                <?php else: ?>
                                    Your registration is pending approval.
                                <?php endif; ?>
                            </p>
                        </div>

                        <?php if ($myRegistration['status'] === 'approved' && $myRegistration['qr_code']): ?>
                            <a href="qr-code.php?id=<?php echo $myRegistration['registration_id']; ?>" class="block w-full bg-employee text-white text-center px-6 py-3 rounded-lg hover:bg-green-700 transition font-semibold mb-3">
                                <i class="fas fa-qrcode mr-2"></i>View QR Code
                            </a>
                        <?php endif; ?>

                        <a href="my-activities.php" class="block w-full bg-gray-200 text-gray-700 text-center px-6 py-3 rounded-lg hover:bg-gray-300 transition font-semibold">
                            <i class="fas fa-list mr-2"></i>My Registrations
                        </a>
                    <?php elseif ($activity['activity_date'] < date('Y-m-d')): ?>
                        <div class="bg-gray-100 border border-gray-300 rounded-lg p-4 text-center">
                            <i class="fas fa-calendar-times text-gray-400 text-3xl mb-2"></i>
                            <p class="text-gray-600 font-semibold">This activity has already passed</p>
                        </div>
                    <?php else: ?>
                        <form method="POST" id="register">
                            <p class="text-gray-700 mb-4">Register for this activity to receive updates and your QR code for attendance.</p>
                            <button type="submit" name="register" class="w-full bg-employee text-white px-6 py-3 rounded-lg hover:bg-green-700 transition font-semibold">
                                <i class="fas fa-user-plus mr-2"></i>Register Now
                            </button>
                        </form>
                    <?php endif; ?>
                </div>

                <!-- Activity Info -->
                <div class="bg-white rounded-xl shadow-lg p-6">
                    <h3 class="text-xl font-bold text-gray-900 mb-4">Quick Info</h3>
                    <div class="space-y-3">
                        <div class="flex items-center justify-between text-sm">
                            <span class="text-gray-600">Category</span>
                            <span class="font-semibold text-gray-900"><?php echo htmlspecialchars($activity['category']); ?></span>
                        </div>
                        <div class="flex items-center justify-between text-sm">
                            <span class="text-gray-600">Quarter</span>
                            <span class="font-semibold text-gray-900">Q<?php echo $activity['quarter']; ?> <?php echo $activity['year']; ?></span>
                        </div>
                        <div class="flex items-center justify-between text-sm">
                            <span class="text-gray-600">Target</span>
                            <span class="font-semibold text-gray-900"><?php echo $activity['target_participants']; ?> pax</span>
                        </div>
                        <div class="flex items-center justify-between text-sm">
                            <span class="text-gray-600">Budget</span>
                            <span class="font-semibold text-gray-900">₱<?php echo number_format($activity['budget'], 2); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>

