<?php
require_once '../config/config.php';
requireRole('employee');

$pageTitle = 'Browse Activities - PSAU GAD';
$db = getDB();
$userId = getCurrentUserId();

// Get filters
$search = $_GET['search'] ?? '';
$category = $_GET['category'] ?? '';
$status = $_GET['status'] ?? 'upcoming';

// Build query
$sql = "SELECT a.*, 
        (SELECT COUNT(*) FROM activity_registrations WHERE activity_id = a.activity_id AND status = 'approved') as registered_count,
        (SELECT COUNT(*) FROM activity_registrations WHERE activity_id = a.activity_id AND user_id = ? AND status != 'rejected') as my_registration
        FROM activities a 
        WHERE a.is_active = 1";

$params = [$userId];

if ($search) {
    $sql .= " AND (a.title LIKE ? OR a.description LIKE ?)";
    $params[] = "%$search%";
    $params[] = "%$search%";
}

if ($category) {
    $sql .= " AND a.category = ?";
    $params[] = $category;
}

if ($status === 'upcoming') {
    $sql .= " AND a.activity_date >= CURDATE()";
} elseif ($status === 'past') {
    $sql .= " AND a.activity_date < CURDATE()";
}

$sql .= " ORDER BY a.activity_date " . ($status === 'past' ? 'DESC' : 'ASC');

$stmt = $db->prepare($sql);
$stmt->execute($params);
$activities = $stmt->fetchAll();

include '../includes/header.php';
include '../includes/navbar.php';
?>

<div class="min-h-screen bg-gray-50 py-8">
    <div class="container mx-auto px-4">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-gray-900 mb-2"><i class="fas fa-calendar-alt text-employee mr-2"></i>Browse Activities</h1>
            <p class="text-gray-600">Discover and register for GAD activities</p>
        </div>

        <!-- Filters -->
        <div class="bg-white rounded-xl shadow-lg p-6 mb-8">
            <form method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Search</label>
                    <input type="text" name="search" value="<?php echo htmlspecialchars($search); ?>" placeholder="Search activities..." class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-employee focus:border-transparent">
                </div>
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Category</label>
                    <select name="category" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-employee focus:border-transparent">
                        <option value="">All Categories</option>
                        <option value="Gender Sensitivity" <?php echo $category === 'Gender Sensitivity' ? 'selected' : ''; ?>>Gender Sensitivity</option>
                        <option value="Women Empowerment" <?php echo $category === 'Women Empowerment' ? 'selected' : ''; ?>>Women Empowerment</option>
                        <option value="LGBTQ+ Rights" <?php echo $category === 'LGBTQ+ Rights' ? 'selected' : ''; ?>>LGBTQ+ Rights</option>
                        <option value="Anti-VAWC" <?php echo $category === 'Anti-VAWC' ? 'selected' : ''; ?>>Anti-VAWC</option>
                        <option value="Other" <?php echo $category === 'Other' ? 'selected' : ''; ?>>Other</option>
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Status</label>
                    <select name="status" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-employee focus:border-transparent">
                        <option value="upcoming" <?php echo $status === 'upcoming' ? 'selected' : ''; ?>>Upcoming</option>
                        <option value="past" <?php echo $status === 'past' ? 'selected' : ''; ?>>Past</option>
                        <option value="all" <?php echo $status === 'all' ? 'selected' : ''; ?>>All</option>
                    </select>
                </div>
                <div class="flex items-end">
                    <button type="submit" class="w-full bg-employee text-white px-6 py-2 rounded-lg hover:bg-green-700 transition"><i class="fas fa-search mr-2"></i>Search</button>
                </div>
            </form>
        </div>

        <!-- Activities Grid -->
        <?php if (empty($activities)): ?>
            <div class="bg-white rounded-xl shadow-lg p-12 text-center">
                <i class="fas fa-calendar-times text-gray-300 text-6xl mb-4"></i>
                <h3 class="text-xl font-bold text-gray-900 mb-2">No Activities Found</h3>
                <p class="text-gray-600">Try adjusting your filters or check back later for new activities.</p>
            </div>
        <?php else: ?>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <?php foreach ($activities as $activity): ?>
                    <div class="bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-xl transition">
                        <div class="bg-gradient-to-r from-employee to-green-600 p-4 text-white">
                            <div class="flex items-center justify-between mb-2">
                                <span class="text-xs font-semibold bg-white bg-opacity-20 px-2 py-1 rounded"><?php echo htmlspecialchars($activity['category']); ?></span>
                                <?php if ($activity['my_registration'] > 0): ?>
                                    <span class="text-xs font-semibold bg-yellow-400 text-gray-900 px-2 py-1 rounded"><i class="fas fa-check mr-1"></i>Registered</span>
                                <?php endif; ?>
                            </div>
                            <h3 class="text-lg font-bold"><?php echo htmlspecialchars($activity['title']); ?></h3>
                        </div>
                        <div class="p-4">
                            <div class="space-y-2 mb-4">
                                <div class="flex items-center text-sm text-gray-600">
                                    <i class="fas fa-calendar w-5 text-employee"></i>
                                    <span><?php echo formatDate($activity['activity_date']); ?></span>
                                </div>
                                <div class="flex items-center text-sm text-gray-600">
                                    <i class="fas fa-clock w-5 text-employee"></i>
                                    <span><?php echo formatTime($activity['start_time']); ?> - <?php echo formatTime($activity['end_time']); ?></span>
                                </div>
                                <div class="flex items-center text-sm text-gray-600">
                                    <i class="fas fa-map-marker-alt w-5 text-employee"></i>
                                    <span><?php echo htmlspecialchars($activity['venue']); ?></span>
                                </div>
                                <div class="flex items-center text-sm text-gray-600">
                                    <i class="fas fa-users w-5 text-employee"></i>
                                    <span><?php echo $activity['registered_count']; ?> / <?php echo $activity['target_participants']; ?> registered</span>
                                </div>
                            </div>
                            <div class="flex items-center justify-between pt-4 border-t border-gray-200">
                                <a href="activity-details.php?id=<?php echo $activity['activity_id']; ?>" class="text-employee hover:text-green-700 font-semibold text-sm">View Details <i class="fas fa-arrow-right ml-1"></i></a>
                                <?php if ($activity['my_registration'] == 0 && $activity['activity_date'] >= date('Y-m-d')): ?>
                                    <a href="activity-details.php?id=<?php echo $activity['activity_id']; ?>#register" class="bg-employee text-white px-4 py-2 rounded-lg hover:bg-green-700 transition text-sm font-semibold">Register</a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include '../includes/footer.php'; ?>

