-- Sample Pre-Tests and Questions

-- Pre-test for Activity 1 (Gender Sensitivity Training)
INSERT INTO pre_tests (activity_id, title, instructions, passing_score, time_limit, created_by, created_at) VALUES
(1, 'Gender Sensitivity Pre-Test', 'This test will assess your current knowledge about gender sensitivity and equality. Please answer all questions honestly. You have 30 minutes to complete this test.', 60, 30, 1, NOW());

SET @test_id = LAST_INSERT_ID();

-- Questions for Gender Sensitivity Pre-Test
INSERT INTO test_questions (test_id, test_type, question_text, question_type, option_a, option_b, option_c, option_d, correct_answer, points, order_num) VALUES
(@test_id, 'pre_test', 'What is gender?', 'multiple_choice', 
 'Biological differences between males and females', 
 'Social and cultural roles, behaviors, and attributes that society considers appropriate for men and women', 
 'The same as sex', 
 'None of the above', 
 'B', 1, 1),

(@test_id, 'pre_test', 'Gender equality means treating everyone exactly the same regardless of their gender.', 'true_false', 
 NULL, NULL, NULL, NULL, 
 'FALSE', 1, 2),

(@test_id, 'pre_test', 'Which of the following is an example of gender stereotyping?', 'multiple_choice', 
 'Assuming women are naturally better at caregiving', 
 'Believing men should not show emotions', 
 'Thinking certain jobs are only for men or women', 
 'All of the above', 
 'D', 1, 3),

(@test_id, 'pre_test', 'GAD stands for:', 'multiple_choice', 
 'Gender and Development', 
 'Gender Against Discrimination', 
 'General Administrative Department', 
 'Gender Awareness Day', 
 'A', 1, 4),

(@test_id, 'pre_test', 'Gender-based violence only affects women.', 'true_false', 
 NULL, NULL, NULL, NULL, 
 'FALSE', 1, 5),

(@test_id, 'pre_test', 'What is the main goal of gender mainstreaming?', 'multiple_choice', 
 'To promote women only', 
 'To integrate gender perspectives into all policies and programs', 
 'To create separate programs for men and women', 
 'To eliminate all gender differences', 
 'B', 1, 6),

(@test_id, 'pre_test', 'The Philippines has a Magna Carta of Women.', 'true_false', 
 NULL, NULL, NULL, NULL, 
 'TRUE', 1, 7),

(@test_id, 'pre_test', 'Which is NOT a dimension of gender equality?', 'multiple_choice', 
 'Equal access to resources', 
 'Equal opportunities', 
 'Equal outcomes', 
 'Equal physical strength', 
 'D', 1, 8),

(@test_id, 'pre_test', 'Gender sensitivity means being aware of and responsive to gender issues.', 'true_false', 
 NULL, NULL, NULL, NULL, 
 'TRUE', 1, 9),

(@test_id, 'pre_test', 'Explain in your own words why gender sensitivity is important in the workplace.', 'essay', 
 NULL, NULL, NULL, NULL, NULL, 2, 10);

-- Pre-test for Activity 2 (Women Empowerment Workshop)
INSERT INTO pre_tests (activity_id, title, instructions, passing_score, time_limit, created_by, created_at) VALUES
(2, 'Women Empowerment Pre-Assessment', 'This assessment will help us understand your current knowledge about women empowerment and rights. Please answer honestly.', 60, 20, 1, NOW());

SET @test_id2 = LAST_INSERT_ID();

-- Questions for Women Empowerment Pre-Test
INSERT INTO test_questions (test_id, test_type, question_text, question_type, option_a, option_b, option_c, option_d, correct_answer, points, order_num) VALUES
(@test_id2, 'pre_test', 'Women empowerment refers to:', 'multiple_choice', 
 'Giving women power over men', 
 'Increasing women\'s ability to make choices and transform those choices into desired actions', 
 'Making women work harder', 
 'Separating women from men', 
 'B', 1, 1),

(@test_id2, 'pre_test', 'Economic empowerment of women includes access to financial resources and decision-making.', 'true_false', 
 NULL, NULL, NULL, NULL, 
 'TRUE', 1, 2),

(@test_id2, 'pre_test', 'Which is a key area of women empowerment?', 'multiple_choice', 
 'Economic participation', 
 'Political participation', 
 'Education and health', 
 'All of the above', 
 'D', 1, 3),

(@test_id2, 'pre_test', 'The glass ceiling refers to:', 'multiple_choice', 
 'A type of building material', 
 'Invisible barriers preventing women from advancing to top positions', 
 'A women\'s organization', 
 'A government policy', 
 'B', 1, 4),

(@test_id2, 'pre_test', 'Women\'s rights are human rights.', 'true_false', 
 NULL, NULL, NULL, NULL, 
 'TRUE', 1, 5);

-- Pre-test for Activity 3 (GAD Planning and Budgeting)
INSERT INTO pre_tests (activity_id, title, instructions, passing_score, time_limit, created_by, created_at) VALUES
(3, 'GAD Planning and Budgeting Pre-Test', 'This test assesses your understanding of GAD planning and budgeting concepts.', 70, 25, 1, NOW());

SET @test_id3 = LAST_INSERT_ID();

-- Questions for GAD Planning Pre-Test
INSERT INTO test_questions (test_id, test_type, question_text, question_type, option_a, option_b, option_c, option_d, correct_answer, points, order_num) VALUES
(@test_id3, 'pre_test', 'GAD Budget refers to:', 'multiple_choice', 
 'A separate budget for women only', 
 'At least 5% of total agency budget for GAD programs', 
 'Money given to GAD focal persons', 
 'Optional budget allocation', 
 'B', 1, 1),

(@test_id3, 'pre_test', 'All government agencies are required to have a GAD Plan and Budget.', 'true_false', 
 NULL, NULL, NULL, NULL, 
 'TRUE', 1, 2),

(@test_id3, 'pre_test', 'The GAD Plan and Budget should be:', 'multiple_choice', 
 'Integrated into the agency\'s overall plans and budget', 
 'Kept separate from regular planning', 
 'Only for women employees', 
 'Optional for agencies', 
 'A', 1, 3),

(@test_id3, 'pre_test', 'PCW stands for:', 'multiple_choice', 
 'Philippine Commission on Women', 
 'Philippine Council for Women', 
 'Philippine Committee on Women', 
 'Philippine Center for Women', 
 'A', 1, 4),

(@test_id3, 'pre_test', 'Gender-responsive budgeting means allocating equal amounts to men and women.', 'true_false', 
 NULL, NULL, NULL, NULL, 
 'FALSE', 1, 5),

(@test_id3, 'pre_test', 'What is the purpose of the GAD Focal Point System?', 'multiple_choice', 
 'To monitor and evaluate GAD programs', 
 'To ensure gender mainstreaming in the agency', 
 'To coordinate GAD activities', 
 'All of the above', 
 'D', 1, 6);

