-- Sample Pre-Test Responses for Testing Analytics
-- This creates realistic test responses for the Gender Sensitivity Training pre-test

-- Get user IDs and test IDs (assuming they exist from previous setup)
SET @test_id = 1; -- Gender Sensitivity Training Pre-Test
SET @user1 = 2; -- John Doe (employee)
SET @user2 = 3; -- Jane Smith (employee)
SET @user3 = 4; -- Bob Johnson (employee)

-- Response 1: John Doe - High Score (Passed)
INSERT INTO pre_test_responses (test_id, user_id, activity_id, score, total_points, percentage, passed, time_taken, submitted_at)
VALUES (@test_id, @user1, 1, 6, 7, 86, 1, 1200, '2024-03-10 10:30:00');

SET @response1 = LAST_INSERT_ID();

-- John's answers (6 correct out of 7)
INSERT INTO test_answers (response_id, test_type, question_id, answer_text, is_correct, points_earned) VALUES
(@response1, 'pre_test', 1, 'A', 1, 1), -- Correct
(@response1, 'pre_test', 2, 'True', 1, 1), -- Correct
(@response1, 'pre_test', 3, 'C', 1, 1), -- Correct
(@response1, 'pre_test', 4, 'B', 1, 1), -- Correct
(@response1, 'pre_test', 5, 'False', 1, 1), -- Correct
(@response1, 'pre_test', 6, 'A', 0, 0), -- Wrong (correct is B)
(@response1, 'pre_test', 7, 'D', 1, 1); -- Correct

-- Response 2: Jane Smith - Perfect Score (Passed)
INSERT INTO pre_test_responses (test_id, user_id, activity_id, score, total_points, percentage, passed, time_taken, submitted_at)
VALUES (@test_id, @user2, 1, 7, 7, 100, 1, 900, '2024-03-10 11:15:00');

SET @response2 = LAST_INSERT_ID();

-- Jane's answers (all correct)
INSERT INTO test_answers (response_id, test_type, question_id, answer_text, is_correct, points_earned) VALUES
(@response2, 'pre_test', 1, 'A', 1, 1),
(@response2, 'pre_test', 2, 'True', 1, 1),
(@response2, 'pre_test', 3, 'C', 1, 1),
(@response2, 'pre_test', 4, 'B', 1, 1),
(@response2, 'pre_test', 5, 'False', 1, 1),
(@response2, 'pre_test', 6, 'B', 1, 1),
(@response2, 'pre_test', 7, 'D', 1, 1);

-- Response 3: Bob Johnson - Low Score (Failed)
INSERT INTO pre_test_responses (test_id, user_id, activity_id, score, total_points, percentage, passed, time_taken, submitted_at)
VALUES (@test_id, @user3, 1, 3, 7, 43, 0, 1500, '2024-03-10 14:20:00');

SET @response3 = LAST_INSERT_ID();

-- Bob's answers (only 3 correct)
INSERT INTO test_answers (response_id, test_type, question_id, answer_text, is_correct, points_earned) VALUES
(@response3, 'pre_test', 1, 'B', 0, 0), -- Wrong
(@response3, 'pre_test', 2, 'False', 0, 0), -- Wrong
(@response3, 'pre_test', 3, 'C', 1, 1), -- Correct
(@response3, 'pre_test', 4, 'A', 0, 0), -- Wrong
(@response3, 'pre_test', 5, 'False', 1, 1), -- Correct
(@response3, 'pre_test', 6, 'A', 0, 0), -- Wrong
(@response3, 'pre_test', 7, 'D', 1, 1); -- Correct

-- Only using 3 employees (IDs 2, 3, 4) for now

-- Sample Post-Test Responses (showing improvement)
SET @post_test_id = 1; -- Gender Sensitivity Training Post-Test

-- Post-Test Response 1: John Doe - Improved Score
INSERT INTO post_test_responses (test_id, user_id, activity_id, score, total_points, percentage, passed, time_taken, submitted_at)
VALUES (@post_test_id, @user1, 1, 8, 9, 89, 1, 1400, '2024-03-15 15:30:00');

SET @post_response1 = LAST_INSERT_ID();

INSERT INTO test_answers (response_id, test_type, question_id, answer_text, is_correct, points_earned) VALUES
(@post_response1, 'post_test', 8, 'B', 1, 1),
(@post_response1, 'post_test', 9, 'True', 1, 1),
(@post_response1, 'post_test', 10, 'C', 1, 1),
(@post_response1, 'post_test', 11, 'A', 1, 1),
(@post_response1, 'post_test', 12, 'False', 1, 1),
(@post_response1, 'post_test', 13, 'D', 1, 1),
(@post_response1, 'post_test', 14, 'B', 1, 1),
(@post_response1, 'post_test', 15, 'True', 1, 1),
(@post_response1, 'post_test', 16, 'A', 0, 0); -- Only 1 wrong

-- Post-Test Response 2: Jane Smith - Still Perfect
INSERT INTO post_test_responses (test_id, user_id, activity_id, score, total_points, percentage, passed, time_taken, submitted_at)
VALUES (@post_test_id, @user2, 1, 9, 9, 100, 1, 1100, '2024-03-15 16:00:00');

SET @post_response2 = LAST_INSERT_ID();

INSERT INTO test_answers (response_id, test_type, question_id, answer_text, is_correct, points_earned) VALUES
(@post_response2, 'post_test', 8, 'B', 1, 1),
(@post_response2, 'post_test', 9, 'True', 1, 1),
(@post_response2, 'post_test', 10, 'C', 1, 1),
(@post_response2, 'post_test', 11, 'A', 1, 1),
(@post_response2, 'post_test', 12, 'False', 1, 1),
(@post_response2, 'post_test', 13, 'D', 1, 1),
(@post_response2, 'post_test', 14, 'B', 1, 1),
(@post_response2, 'post_test', 15, 'True', 1, 1),
(@post_response2, 'post_test', 16, 'A', 1, 1);

-- Post-Test Response 3: Bob Johnson - Significant Improvement (Now Passed!)
INSERT INTO post_test_responses (test_id, user_id, activity_id, score, total_points, percentage, passed, time_taken, submitted_at)
VALUES (@post_test_id, @user3, 1, 7, 9, 78, 1, 1600, '2024-03-15 16:30:00');

SET @post_response3 = LAST_INSERT_ID();

INSERT INTO test_answers (response_id, test_type, question_id, answer_text, is_correct, points_earned) VALUES
(@post_response3, 'post_test', 8, 'B', 1, 1),
(@post_response3, 'post_test', 9, 'True', 1, 1),
(@post_response3, 'post_test', 10, 'C', 1, 1),
(@post_response3, 'post_test', 11, 'B', 0, 0), -- Wrong
(@post_response3, 'post_test', 12, 'False', 1, 1),
(@post_response3, 'post_test', 13, 'D', 1, 1),
(@post_response3, 'post_test', 14, 'B', 1, 1),
(@post_response3, 'post_test', 15, 'False', 0, 0), -- Wrong
(@post_response3, 'post_test', 16, 'A', 1, 1);

-- Only using 3 employees for now

