-- Sample Post-Tests and Questions

-- Post-test for Activity 1 (Gender Sensitivity Training)
INSERT INTO post_tests (activity_id, title, instructions, passing_score, time_limit, created_by, created_at) VALUES
(1, 'Gender Sensitivity Post-Test', 'This test will assess what you have learned from the Gender Sensitivity Training. Please answer all questions based on what you learned during the activity.', 70, 30, 1, NOW());

SET @test_id = LAST_INSERT_ID();

-- Questions for Gender Sensitivity Post-Test
INSERT INTO test_questions (test_id, test_type, question_text, question_type, option_a, option_b, option_c, option_d, correct_answer, points, order_num) VALUES
(@test_id, 'post_test', 'Gender refers to:', 'multiple_choice', 
 'Biological sex', 
 'Socially constructed roles and behaviors', 
 'Physical characteristics', 
 'Genetic makeup', 
 'B', 1, 1),

(@test_id, 'post_test', 'Gender mainstreaming means integrating gender perspectives into all policies and programs.', 'true_false', 
 NULL, NULL, NULL, NULL, 
 'TRUE', 1, 2),

(@test_id, 'post_test', 'Which of the following promotes gender equality in the workplace?', 'multiple_choice', 
 'Equal pay for equal work', 
 'Equal opportunities for promotion', 
 'Zero tolerance for harassment', 
 'All of the above', 
 'D', 1, 3),

(@test_id, 'post_test', 'The Magna Carta of Women was enacted in what year?', 'multiple_choice', 
 '2007', 
 '2008', 
 '2009', 
 '2010', 
 'C', 1, 4),

(@test_id, 'post_test', 'Gender-based violence can happen to anyone regardless of gender.', 'true_false', 
 NULL, NULL, NULL, NULL, 
 'TRUE', 1, 5),

(@test_id, 'post_test', 'What is the primary goal of GAD programs?', 'multiple_choice', 
 'To favor women over men', 
 'To achieve gender equality and equity', 
 'To create separate programs', 
 'To eliminate gender differences', 
 'B', 1, 6),

(@test_id, 'post_test', 'Gender sensitivity training is only important for women.', 'true_false', 
 NULL, NULL, NULL, NULL, 
 'FALSE', 1, 7),

(@test_id, 'post_test', 'Which is a key principle of gender equality?', 'multiple_choice', 
 'Equal access to resources', 
 'Equal participation in decision-making', 
 'Equal benefits from development', 
 'All of the above', 
 'D', 1, 8),

(@test_id, 'post_test', 'Stereotyping limits opportunities for both men and women.', 'true_false', 
 NULL, NULL, NULL, NULL, 
 'TRUE', 1, 9),

(@test_id, 'post_test', 'Based on what you learned, how can you promote gender sensitivity in your workplace? Provide specific examples.', 'essay', 
 NULL, NULL, NULL, NULL, NULL, 2, 10);

-- Post-test for Activity 2 (Women Empowerment Workshop)
INSERT INTO post_tests (activity_id, title, instructions, passing_score, time_limit, created_by, created_at) VALUES
(2, 'Women Empowerment Post-Assessment', 'This assessment will measure your understanding of women empowerment concepts after the workshop.', 70, 20, 1, NOW());

SET @test_id2 = LAST_INSERT_ID();

-- Questions for Women Empowerment Post-Test
INSERT INTO test_questions (test_id, test_type, question_text, question_type, option_a, option_b, option_c, option_d, correct_answer, points, order_num) VALUES
(@test_id2, 'post_test', 'Women empowerment is about:', 'multiple_choice', 
 'Giving women control over men', 
 'Enabling women to make strategic life choices', 
 'Making women independent from family', 
 'Promoting women only', 
 'B', 1, 1),

(@test_id2, 'post_test', 'Economic empowerment includes access to credit, property rights, and income-generating activities.', 'true_false', 
 NULL, NULL, NULL, NULL, 
 'TRUE', 1, 2),

(@test_id2, 'post_test', 'The five dimensions of women empowerment include:', 'multiple_choice', 
 'Economic, social, political, legal, and psychological', 
 'Only economic and social', 
 'Only political and legal', 
 'Only psychological', 
 'A', 1, 3),

(@test_id2, 'post_test', 'What does the "glass ceiling" represent?', 'multiple_choice', 
 'A physical barrier in buildings', 
 'Invisible barriers preventing women from reaching top positions', 
 'A type of discrimination law', 
 'A women\'s support group', 
 'B', 1, 4),

(@test_id2, 'post_test', 'Women\'s empowerment benefits only women.', 'true_false', 
 NULL, NULL, NULL, NULL, 
 'FALSE', 1, 5),

(@test_id2, 'post_test', 'Which is NOT a strategy for women empowerment?', 'multiple_choice', 
 'Education and skills training', 
 'Access to leadership positions', 
 'Limiting women to traditional roles', 
 'Promoting women\'s rights', 
 'C', 1, 6),

(@test_id2, 'post_test', 'Describe two ways you can support women empowerment in your community.', 'essay', 
 NULL, NULL, NULL, NULL, NULL, 2, 7);

-- Post-test for Activity 3 (GAD Planning and Budgeting)
INSERT INTO post_tests (activity_id, title, instructions, passing_score, time_limit, created_by, created_at) VALUES
(3, 'GAD Planning and Budgeting Post-Test', 'This test evaluates your understanding of GAD planning and budgeting after the training.', 75, 25, 1, NOW());

SET @test_id3 = LAST_INSERT_ID();

-- Questions for GAD Planning Post-Test
INSERT INTO test_questions (test_id, test_type, question_text, question_type, option_a, option_b, option_c, option_d, correct_answer, points, order_num) VALUES
(@test_id3, 'post_test', 'The minimum GAD budget allocation for government agencies is:', 'multiple_choice', 
 '3% of total budget', 
 '5% of total budget', 
 '10% of total budget', 
 '15% of total budget', 
 'B', 1, 1),

(@test_id3, 'post_test', 'GAD Plan and Budget must be submitted annually to PCW.', 'true_false', 
 NULL, NULL, NULL, NULL, 
 'TRUE', 1, 2),

(@test_id3, 'post_test', 'The GAD Plan and Budget should address:', 'multiple_choice', 
 'Client-focused programs', 
 'Organization-focused programs', 
 'Both client and organization-focused programs', 
 'Neither client nor organization programs', 
 'C', 1, 3),

(@test_id3, 'post_test', 'PCW stands for:', 'multiple_choice', 
 'Philippine Commission on Women', 
 'Philippine Council for Women', 
 'Philippine Committee on Women', 
 'Philippine Center for Women', 
 'A', 1, 4),

(@test_id3, 'post_test', 'Gender-responsive budgeting means allocating exactly 50% to men and 50% to women.', 'true_false', 
 NULL, NULL, NULL, NULL, 
 'FALSE', 1, 5),

(@test_id3, 'post_test', 'The GAD Focal Point System is responsible for:', 'multiple_choice', 
 'Monitoring GAD implementation', 
 'Coordinating GAD activities', 
 'Ensuring gender mainstreaming', 
 'All of the above', 
 'D', 1, 6),

(@test_id3, 'post_test', 'Gender analysis is important in planning because:', 'multiple_choice', 
 'It identifies different needs of men and women', 
 'It ensures programs benefit everyone equitably', 
 'It helps allocate resources effectively', 
 'All of the above', 
 'D', 1, 7),

(@test_id3, 'post_test', 'The GAD budget can be used for any program as long as it mentions gender.', 'true_false', 
 NULL, NULL, NULL, NULL, 
 'FALSE', 1, 8);

