-- Sample Evaluation Forms and Questions

-- Evaluation for Activity 1 (Gender Sensitivity Training)
INSERT INTO evaluation_forms (activity_id, title, instructions, created_by, created_at) VALUES
(1, 'Gender Sensitivity Training Evaluation', 'Please take a moment to evaluate this training. Your feedback helps us improve future programs.', 1, NOW());

SET @form_id = LAST_INSERT_ID();

-- Questions for Gender Sensitivity Training Evaluation
INSERT INTO evaluation_questions (form_id, question_text, question_type, is_required, order_num) VALUES
(@form_id, 'How would you rate the overall quality of this training?', 'rating', 1, 1),
(@form_id, 'The training objectives were clearly defined and met.', 'rating', 1, 2),
(@form_id, 'The facilitator was knowledgeable and engaging.', 'rating', 1, 3),
(@form_id, 'The training materials were helpful and relevant.', 'rating', 1, 4),
(@form_id, 'The training duration was appropriate.', 'rating', 1, 5),
(@form_id, 'Would you recommend this training to others?', 'yes_no', 1, 6),
(@form_id, 'What did you find most valuable about this training?', 'text', 1, 7),
(@form_id, 'What suggestions do you have for improving this training?', 'text', 0, 8),
(@form_id, 'How will you apply what you learned in your work?', 'text', 1, 9);

-- Evaluation for Activity 2 (Women Empowerment Workshop)
INSERT INTO evaluation_forms (activity_id, title, instructions, created_by, created_at) VALUES
(2, 'Women Empowerment Workshop Evaluation', 'Your feedback is valuable! Please share your thoughts about the workshop.', 1, NOW());

SET @form_id2 = LAST_INSERT_ID();

-- Questions for Women Empowerment Workshop Evaluation
INSERT INTO evaluation_questions (form_id, question_text, question_type, is_required, order_num) VALUES
(@form_id2, 'Overall, how would you rate this workshop?', 'rating', 1, 1),
(@form_id2, 'The workshop content was relevant to my needs.', 'rating', 1, 2),
(@form_id2, 'The facilitator effectively engaged participants.', 'rating', 1, 3),
(@form_id2, 'The workshop venue and facilities were adequate.', 'rating', 1, 4),
(@form_id2, 'I gained new knowledge and skills from this workshop.', 'rating', 1, 5),
(@form_id2, 'Did the workshop meet your expectations?', 'yes_no', 1, 6),
(@form_id2, 'What was the most impactful part of the workshop?', 'text', 1, 7),
(@form_id2, 'What topics would you like to see in future workshops?', 'text', 0, 8);

-- Evaluation for Activity 3 (GAD Planning and Budgeting)
INSERT INTO evaluation_forms (activity_id, title, instructions, created_by, created_at) VALUES
(3, 'GAD Planning and Budgeting Training Evaluation', 'Help us improve! Please provide your honest feedback about this training.', 1, NOW());

SET @form_id3 = LAST_INSERT_ID();

-- Questions for GAD Planning and Budgeting Evaluation
INSERT INTO evaluation_questions (form_id, question_text, question_type, is_required, order_num) VALUES
(@form_id3, 'How would you rate the overall training experience?', 'rating', 1, 1),
(@form_id3, 'The training objectives were clearly communicated.', 'rating', 1, 2),
(@form_id3, 'The content was well-organized and easy to follow.', 'rating', 1, 3),
(@form_id3, 'The facilitator demonstrated expertise in the subject.', 'rating', 1, 4),
(@form_id3, 'The training materials and resources were useful.', 'rating', 1, 5),
(@form_id3, 'The training schedule and timing were appropriate.', 'rating', 1, 6),
(@form_id3, 'I feel confident applying GAD planning and budgeting concepts.', 'rating', 1, 7),
(@form_id3, 'Would you attend similar trainings in the future?', 'yes_no', 1, 8),
(@form_id3, 'What specific skills or knowledge did you gain?', 'text', 1, 9),
(@form_id3, 'How can we improve future GAD trainings?', 'text', 0, 10);

