<?php
/**
 * Main Configuration File
 * PSAU GAD Information System
 */

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Base paths (define early for error logging)
define('BASE_PATH', dirname(__DIR__));
define('BASE_URL', 'http://localhost/GAD');

// Error reporting and logging
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', BASE_PATH . '/logs/php_errors.log');

// Timezone
date_default_timezone_set('Asia/Manila');

// Directory paths
define('ASSETS_PATH', BASE_PATH . '/assets');
define('UPLOADS_PATH', BASE_PATH . '/uploads');
define('INCLUDES_PATH', BASE_PATH . '/includes');
define('CONFIG_PATH', BASE_PATH . '/config');

// URL paths
define('ASSETS_URL', BASE_URL . '/assets');
define('UPLOADS_URL', BASE_URL . '/uploads');

// Upload directories
define('PROFILE_IMAGES_PATH', UPLOADS_PATH . '/profiles');
define('CERTIFICATES_PATH', UPLOADS_PATH . '/certificates');
define('RESOURCES_PATH', UPLOADS_PATH . '/resources');
define('QR_CODES_PATH', UPLOADS_PATH . '/qr_codes');

// Create upload directories if they don't exist
$upload_dirs = [
    UPLOADS_PATH,
    PROFILE_IMAGES_PATH,
    CERTIFICATES_PATH,
    RESOURCES_PATH,
    QR_CODES_PATH
];

foreach ($upload_dirs as $dir) {
    if (!file_exists($dir)) {
        @mkdir($dir, 0777, true);
    }
}

// System settings
define('SITE_NAME', 'PSAU GAD Information System');
define('SITE_EMAIL', 'gad@psau.edu.ph');
define('ATTENDANCE_GRACE_PERIOD', 20); // minutes

// Roles
define('ROLE_ADMIN', 'admin');
define('ROLE_EMPLOYEE', 'employee');
define('ROLE_SECRETARIAT', 'secretariat');

// Email configuration (PHPMailer)
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', ''); // Set your email
define('SMTP_PASSWORD', ''); // Set your app password
define('SMTP_ENCRYPTION', 'tls');
define('SMTP_FROM_EMAIL', SITE_EMAIL);
define('SMTP_FROM_NAME', SITE_NAME);

// Pagination
define('ITEMS_PER_PAGE', 10);

// File upload limits
define('MAX_FILE_SIZE', 10 * 1024 * 1024); // 10MB
define('ALLOWED_IMAGE_TYPES', ['image/jpeg', 'image/png', 'image/gif']);
define('ALLOWED_DOCUMENT_TYPES', ['application/pdf', 'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document']);
define('ALLOWED_VIDEO_TYPES', ['video/mp4', 'video/mpeg', 'video/quicktime']);

// Security
define('PASSWORD_MIN_LENGTH', 8);
define('SESSION_TIMEOUT', 3600); // 1 hour in seconds

// Include database configuration
require_once CONFIG_PATH . '/database.php';

// Autoload classes
spl_autoload_register(function ($class) {
    $file = INCLUDES_PATH . '/classes/' . $class . '.php';
    if (file_exists($file)) {
        require_once $file;
    }
});

// Helper functions
require_once INCLUDES_PATH . '/functions.php';

