# PSAU GAD Information System

Gender and Development Information System for Pampanga State Agricultural University

## 🚀 Technology Stack

- **Backend**: Vanilla PHP 8.x
- **Frontend**: Tailwind CSS (via CDN)
- **Database**: MySQL/MariaDB
- **Email**: PHPMailer (via Composer)
- **QR Code**: QR Server API (via CDN)
- **Charts**: Chart.js (via CDN)
- **Calendar**: FullCalendar (via CDN)
- **Icons**: Font Awesome (via CDN)

## 📋 Prerequisites

- XAMPP (Apache + MySQL + PHP 8.x)
- Composer (for PHPMailer)
- Modern web browser

## 🛠️ Installation Steps

### 1. Clone/Copy Project

Copy the GAD folder to your XAMPP htdocs directory:
```
/Applications/XAMPP/xamppfiles/htdocs/GAD
```

### 2. Install PHPMailer via Composer

Open terminal in the project directory and run:
```bash
cd /Applications/XAMPP/xamppfiles/htdocs/GAD
composer require phpmailer/phpmailer
```

### 3. Create Database

1. Start XAMPP (Apache and MySQL)
2. Open phpMyAdmin: http://localhost/phpmyadmin
3. Import the database schema:
   - Click "Import" tab
   - Choose file: `database/schema.sql`
   - Click "Go"

Alternatively, run this command in terminal:
```bash
mysql -u root -p < database/schema.sql
```

### 4. Configure Database Connection

Edit `config/database.php` if needed (default settings):
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'gad_system');
define('DB_USER', 'root');
define('DB_PASS', '');
```

### 5. Configure Email Settings

Edit `config/config.php` and update SMTP settings:
```php
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', 'your-email@gmail.com');
define('SMTP_PASSWORD', 'your-app-password');
```

**Note**: For Gmail, you need to:
1. Enable 2-factor authentication
2. Generate an App Password
3. Use the App Password in the config

### 6. Set Permissions

Ensure upload directories are writable:
```bash
chmod -R 755 uploads/
```

### 7. Access the System

Open your browser and navigate to:
```
http://localhost/GAD
```

## 👥 User Roles

### 1. Employee
- Register for activities
- Take pre/post tests
- View and download certificates
- Submit contact messages

### 2. Secretariat
- Manage activities
- Approve registrations
- Mark attendance (QR scanner + walk-in)
- View reports and analytics
- Monitor forms

### 3. Admin
- Full system access
- Manage users and permissions
- Generate reports
- System settings
- Resource library management

## 🔐 Default Login Credentials

After installation, you need to create admin account manually in the database or register with a PSAU email (@psau.edu.ph) which will be auto-approved.

To create admin manually:
```sql
INSERT INTO users (email, password_hash, role, is_psau_account, is_approved, is_active)
VALUES ('admin@psau.edu.ph', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', 1, 1, 1);
-- Password: password
```

## 📁 Project Structure

```
GAD/
├── config/
│   ├── config.php          # Main configuration
│   └── database.php        # Database connection
├── database/
│   └── schema.sql          # Database schema
├── includes/
│   ├── classes/
│   │   ├── Auth.php        # Authentication
│   │   ├── Email.php       # Email handling
│   │   └── QRCode.php      # QR code generation
│   ├── functions.php       # Helper functions
│   ├── header.php          # HTML header
│   ├── footer.php          # HTML footer
│   └── navbar.php          # Navigation bar
├── uploads/
│   ├── profiles/           # Profile images
│   ├── certificates/       # Generated certificates
│   ├── resources/          # Resource library files
│   └── qr_codes/          # QR codes
├── employee/              # Employee module (to be created)
├── admin/                 # Admin module (to be created)
├── secretariat/           # Secretariat module (to be created)
├── index.php             # Public home page
├── login.php             # Login page
├── register.php          # Registration page
├── logout.php            # Logout handler
└── README.md             # This file
```

## 🎨 Design System

The system uses a custom color palette based on the CSS_STYLE_GUIDE.md:

- **Primary Purple**: #8b5cf6 (Main theme)
- **Admin Blue**: #3b82f6
- **Employee Green**: #10b981
- **Secretariat Yellow**: #fbbf24

All styling is done with Tailwind CSS configured to match these colors.

## 📧 Email Notifications

The system sends automated emails for:
1. Registration confirmation
2. Registration approval (with pre-test link)
3. QR code for attendance
4. Post-test and evaluation reminder
5. Certificate availability

## 📱 QR Code System

- QR codes are generated using QR Server API
- Each registration gets a unique QR code
- QR codes are sent via email
- Can be scanned for attendance marking
- Supports walk-in attendance as well

## 🔄 Next Steps

### Phase 2: Authentication System ✅ (Completed)
- Login/Register pages
- Session management
- Role-based access control

### Phase 3: Employee Module (In Progress)
- Dashboard with calendar
- Activity registration
- Pre/Post tests
- Certificate viewing

### Phase 4: Admin Module
- Dashboard with analytics
- Activity management
- Report generation
- User management

### Phase 5: Secretariat Module
- Dashboard
- Attendance management
- QR scanner interface
- Monitoring forms

### Phase 6: Shared Features
- Calendar integration
- Chart.js analytics
- PDF generation for reports
- Resource library

## 🐛 Troubleshooting

### Database Connection Error
- Check if MySQL is running in XAMPP
- Verify database credentials in `config/database.php`
- Ensure database `gad_system` exists

### Email Not Sending
- Verify SMTP credentials
- Check if Gmail App Password is correct
- Ensure port 587 is not blocked

### Upload Errors
- Check folder permissions (755 or 777)
- Verify upload directories exist
- Check PHP upload_max_filesize setting

### Session Issues
- Clear browser cookies
- Check if session.save_path is writable
- Restart Apache

## 📞 Support

For issues or questions, contact:
- Email: gad@psau.edu.ph
- Phone: (045) 123-4567

## 📄 License

© 2025 Pampanga State Agricultural University. All rights reserved.

## 🙏 Credits

Developed for PSAU Gender and Development Office

