# PSAU GAD System - Quick Start Guide

## ⚡ 5-Minute Setup

### Prerequisites
- XAMPP installed and running
- Composer installed
- Terminal/Command Prompt access

### Step 1: Install Dependencies (1 minute)
```bash
cd /Applications/XAMPP/xamppfiles/htdocs/GAD
composer install
```

### Step 2: Create Database (1 minute)
```bash
# Open phpMyAdmin
open http://localhost/phpmyadmin

# Import database/schema.sql
# OR use command line:
mysql -u root < database/schema.sql
```

### Step 3: Create Admin Account (1 minute)
```sql
-- Run in phpMyAdmin SQL tab
INSERT INTO users (email, password_hash, role, is_psau_account, is_approved, is_active)
VALUES ('admin@psau.edu.ph', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', 1, 1, 1);

INSERT INTO employee_profiles (user_id, first_name, last_name, gender, category)
VALUES (1, 'Admin', 'User', 'Other', 'Other');
```

### Step 4: Access System (30 seconds)
```
http://localhost/GAD
```

**Login:**
- Email: `admin@psau.edu.ph`
- Password: `password`

### Step 5: Test Registration (1 minute)
1. Click "Register"
2. Use email: `test@psau.edu.ph`
3. Fill form and submit
4. Login with new account

---

## 🎯 What's Working Now

✅ **Authentication**
- Login/Register
- Role-based access (Admin, Employee, Secretariat)
- PSAU email auto-approval
- Session management

✅ **Employee Features**
- Dashboard with stats
- View upcoming activities
- View registrations

✅ **Core Systems**
- Database (20+ tables)
- Email notifications (PHPMailer)
- QR code generation
- File uploads

---

## 🚧 What's Next to Build

### Priority 1: Employee Module
- Activity registration form
- Pre/Post test interface
- Certificate viewing
- Profile editing

### Priority 2: Admin Module
- Activity CRUD
- User management
- Report generation
- Approvals interface

### Priority 3: Secretariat Module
- QR scanner
- Attendance marking
- Monitoring forms

---

## 📝 Quick Reference

### File Locations
```
Login Page:        /login.php
Register Page:     /register.php
Employee Dashboard: /employee/dashboard.php
Database Schema:   /database/schema.sql
Config:            /config/config.php
```

### Database
```
Database Name: gad_system
User:          root
Password:      (empty)
Host:          localhost
```

### Default Credentials
```
Admin:
  Email:    admin@psau.edu.ph
  Password: password
```

### Important Functions
```php
// Check if logged in
isLoggedIn()

// Get current user
getCurrentUserId()
getCurrentUserRole()

// Require login
requireLogin()
requireRole('admin')

// Flash messages
setFlashMessage('success', 'Message')
displayFlashMessage()

// Database
$db = getDB()
```

---

## 🐛 Common Issues

**Issue:** Database connection failed  
**Fix:** Start MySQL in XAMPP

**Issue:** Class 'PHPMailer' not found  
**Fix:** Run `composer install`

**Issue:** Permission denied  
**Fix:** `chmod -R 755 uploads/`

**Issue:** Blank page  
**Fix:** Check `logs/error.log`

---

## 📚 Documentation

- `README.md` - Full documentation
- `INSTALLATION_GUIDE.md` - Detailed setup
- `PROJECT_SUMMARY.md` - Project overview
- `CSS_STYLE_GUIDE.md` - Design system

---

## 🎨 Design Colors

```css
Primary:     #8b5cf6  /* Purple */
Admin:       #3b82f6  /* Blue */
Employee:    #10b981  /* Green */
Secretariat: #fbbf24  /* Yellow */
```

---

## 💡 Development Tips

1. **Always use prepared statements** for database queries
2. **Sanitize all inputs** using `sanitize()` function
3. **Use role checks** before sensitive operations
4. **Log errors** using `logError()` function
5. **Follow Tailwind CSS** classes for styling
6. **Test on mobile** - system is responsive

---

## 🚀 Next Steps

1. ✅ Complete Phase 1 & 2
2. ⏳ Build Employee Module (Phase 3)
3. ⏳ Build Admin Module (Phase 4)
4. ⏳ Build Secretariat Module (Phase 5)
5. ⏳ Add Charts & Calendar (Phase 6)

---

**Ready to code!** 🎉

Start with: `/employee/activities.php` to build activity listing page.

