# PSAU GAD System - Complete Installation Guide

## 📋 Table of Contents
1. [System Requirements](#system-requirements)
2. [Installation Steps](#installation-steps)
3. [Database Setup](#database-setup)
4. [Configuration](#configuration)
5. [Testing the System](#testing-the-system)
6. [Troubleshooting](#troubleshooting)

---

## 🖥️ System Requirements

### Required Software
- **XAMPP** (Latest version with PHP 8.0+)
  - Apache Web Server
  - MySQL/MariaDB
  - PHP 8.0 or higher
- **Composer** (for dependency management)
- **Modern Web Browser** (Chrome, Firefox, Safari, Edge)

### Server Requirements
- PHP 8.0+
- MySQL 5.7+ or MariaDB 10.3+
- Apache with mod_rewrite enabled
- Minimum 512MB RAM
- 100MB free disk space

---

## 🚀 Installation Steps

### Step 1: Start XAMPP

1. Open XAMPP Control Panel
2. Start **Apache** server
3. Start **MySQL** server
4. Verify both are running (green indicators)

### Step 2: Install Composer (if not installed)

**For macOS:**
```bash
# Download and install Composer
curl -sS https://getcomposer.org/installer | php
sudo mv composer.phar /usr/local/bin/composer

# Verify installation
composer --version
```

**For Windows:**
- Download from: https://getcomposer.org/download/
- Run the installer
- Follow the installation wizard

### Step 3: Install PHPMailer

Open Terminal/Command Prompt and navigate to the project directory:

```bash
cd /Applications/XAMPP/xamppfiles/htdocs/GAD
composer install
```

This will install PHPMailer and create the `vendor` directory.

---

## 💾 Database Setup

### Option 1: Using phpMyAdmin (Recommended for beginners)

1. Open browser and go to: `http://localhost/phpmyadmin`
2. Click on **"Import"** tab
3. Click **"Choose File"** and select: `database/schema.sql`
4. Click **"Go"** button at the bottom
5. Wait for success message

### Option 2: Using MySQL Command Line

```bash
# Navigate to XAMPP MySQL bin directory
cd /Applications/XAMPP/xamppfiles/bin

# Login to MySQL
./mysql -u root -p

# When prompted, press Enter (default: no password)

# Run the schema file
source /Applications/XAMPP/xamppfiles/htdocs/GAD/database/schema.sql

# Exit MySQL
exit;
```

### Verify Database Creation

1. Go to phpMyAdmin: `http://localhost/phpmyadmin`
2. You should see `gad_system` database in the left sidebar
3. Click on it to see all tables (should have 20+ tables)

---

## ⚙️ Configuration

### 1. Database Configuration

File: `config/database.php`

Default settings (usually no changes needed):
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'gad_system');
define('DB_USER', 'root');
define('DB_PASS', '');  // Empty for default XAMPP
```

### 2. Email Configuration (SMTP)

File: `config/config.php`

**For Gmail:**

1. Enable 2-Factor Authentication on your Gmail account
2. Generate App Password:
   - Go to: https://myaccount.google.com/security
   - Click "2-Step Verification"
   - Scroll to "App passwords"
   - Generate new app password
   - Copy the 16-character password

3. Update config:
```php
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', 'your-email@gmail.com');
define('SMTP_PASSWORD', 'your-16-char-app-password');
define('SMTP_ENCRYPTION', 'tls');
```

**For Other Email Providers:**
- Update SMTP_HOST, SMTP_PORT accordingly
- Check your email provider's SMTP settings

### 3. Base URL Configuration

File: `config/config.php`

Update if your project is in a different location:
```php
define('BASE_URL', 'http://localhost/GAD');
```

### 4. File Permissions

Ensure upload directories are writable:

**macOS/Linux:**
```bash
chmod -R 755 uploads/
chmod -R 755 logs/
```

**Windows:**
- Right-click folders → Properties → Security
- Ensure "Users" have Write permissions

---

## 🧪 Testing the System

### 1. Access the Homepage

Open browser and navigate to:
```
http://localhost/GAD
```

You should see the PSAU GAD homepage with:
- Purple gradient header
- Vision, Mission, Goals sections
- Upcoming activities preview
- Login/Register buttons

### 2. Create Admin Account

**Option A: Using SQL (Recommended)**

1. Go to phpMyAdmin
2. Select `gad_system` database
3. Click "SQL" tab
4. Run this query:

```sql
INSERT INTO users (email, password_hash, role, is_psau_account, is_approved, is_active)
VALUES ('admin@psau.edu.ph', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', 1, 1, 1);

-- Get the user_id from the insert (usually 1)
INSERT INTO employee_profiles (user_id, first_name, last_name, gender, category)
VALUES (1, 'Admin', 'User', 'Other', 'Other');
```

**Login Credentials:**
- Email: `admin@psau.edu.ph`
- Password: `password`

**Option B: Register with PSAU Email**

1. Click "Register" on homepage
2. Use email ending with `@psau.edu.ph`
3. Fill in the form
4. Account will be auto-approved
5. Login with your credentials

### 3. Test Employee Registration

1. Click "Register"
2. Fill in the form with:
   - First Name: Test
   - Last Name: Employee
   - Gender: Select one
   - Category: Faculty
   - Email: test@example.com (non-PSAU)
   - Password: password123
3. Submit form
4. You should see: "Registration successful! Please wait for admin approval."

### 4. Test Login

1. Click "Login"
2. Enter credentials
3. You should be redirected to role-specific dashboard

### 5. Verify Email Functionality (Optional)

1. Register a new account
2. Check if email is sent (check spam folder)
3. If emails not working, verify SMTP settings

---

## 🔧 Troubleshooting

### Issue: "Database connection failed"

**Solution:**
1. Verify MySQL is running in XAMPP
2. Check database credentials in `config/database.php`
3. Ensure `gad_system` database exists
4. Try restarting MySQL in XAMPP

### Issue: "Class 'PHPMailer' not found"

**Solution:**
```bash
cd /Applications/XAMPP/xamppfiles/htdocs/GAD
composer install
```

### Issue: "Permission denied" for uploads

**Solution:**
```bash
chmod -R 755 uploads/
chmod -R 755 logs/
```

### Issue: Emails not sending

**Solutions:**
1. Verify SMTP credentials are correct
2. Check if Gmail App Password is used (not regular password)
3. Ensure port 587 is not blocked by firewall
4. Check `logs/error.log` for email errors
5. Test with a different email provider

### Issue: "Session timeout" or "Not logged in"

**Solution:**
1. Clear browser cookies
2. Check if session.save_path is writable
3. Restart Apache in XAMPP
4. Try different browser

### Issue: Blank page or white screen

**Solution:**
1. Enable error reporting in `config/config.php`:
```php
error_reporting(E_ALL);
ini_set('display_errors', 1);
```
2. Check `logs/error.log`
3. Verify all files are uploaded correctly
4. Check Apache error logs in XAMPP

### Issue: CSS/Styling not loading

**Solution:**
1. Check if Tailwind CSS CDN is accessible
2. Clear browser cache (Ctrl+Shift+Delete)
3. Check browser console for errors (F12)
4. Verify internet connection (CDN requires internet)

### Issue: 404 errors for pages

**Solution:**
1. Verify `.htaccess` file exists
2. Enable mod_rewrite in Apache:
   - Edit `httpd.conf`
   - Uncomment: `LoadModule rewrite_module modules/mod_rewrite.so`
   - Restart Apache
3. Check file paths are correct

---

## 📞 Getting Help

If you encounter issues not covered here:

1. **Check Error Logs:**
   - `logs/error.log` (application errors)
   - XAMPP Apache error logs
   - Browser console (F12)

2. **Verify Installation:**
   - All files present
   - Composer dependencies installed
   - Database created successfully
   - Correct file permissions

3. **Contact Support:**
   - Email: gad@psau.edu.ph
   - Include error messages and screenshots

---

## ✅ Post-Installation Checklist

- [ ] XAMPP Apache and MySQL running
- [ ] Composer installed
- [ ] PHPMailer installed via Composer
- [ ] Database `gad_system` created
- [ ] All tables present in database
- [ ] Admin account created
- [ ] Can access homepage at `http://localhost/GAD`
- [ ] Can login successfully
- [ ] Upload directories writable
- [ ] Email configuration set (optional for testing)

---

## 🎉 Success!

If all steps completed successfully, you should now have a fully functional PSAU GAD Information System!

**Next Steps:**
1. Login as admin
2. Explore the dashboard
3. Create test activities
4. Test employee registration workflow
5. Customize system settings

---

**Version:** 1.0.0  
**Last Updated:** 2025-11-03  
**Developed for:** Pampanga State Agricultural University

