# PSAU GAD System - CSS Style Guide

## 📋 Overview

This document provides a complete reference for the CSS styling system used in the PSAU Gender and Development Information System.

---

## 📁 Files Created

1. **`DESIGN_SYSTEM.json`** - Complete design system in JSON format
2. **`assets/css/gad-system.css`** - Main stylesheet (854 lines)
3. **`CSS_STYLE_GUIDE.md`** - This documentation file

---

## 🎨 Color Palette

### Primary Colors
```css
--color-primary: #8b5cf6        /* Main purple */
--color-primary-light: #a78bfa  /* Light purple */
--color-primary-dark: #7c3aed   /* Dark purple */
```

### Role-Based Colors

#### Admin (Blue)
```css
--color-admin: #3b82f6
--color-admin-light: #60a5fa
--color-admin-dark: #2563eb
--color-admin-bg: #dbeafe
```

#### Employee (Green)
```css
--color-employee: #10b981
--color-employee-light: #34d399
--color-employee-dark: #059669
--color-employee-bg: #d1fae5
```

#### Secretariat (Yellow/Gold)
```css
--color-secretariat: #fbbf24
--color-secretariat-light: #fcd34d
--color-secretariat-dark: #f59e0b
--color-secretariat-bg: #fef3c7
```

### Semantic Colors
```css
--color-success: #10b981
--color-warning: #f59e0b
--color-error: #ef4444
--color-info: #3b82f6
```

### Neutral Colors
```css
--color-white: #ffffff
--color-gray-50: #f9fafb
--color-gray-100: #f3f4f6
--color-gray-200: #e5e7eb
--color-gray-300: #d1d5db
--color-gray-400: #9ca3af
--color-gray-500: #6b7280
--color-gray-600: #4b5563
--color-gray-700: #374151
--color-gray-800: #1f2937
--color-gray-900: #111827
--color-black: #000000
```

---

## 🔤 Typography

### Font Families
```css
--font-primary: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif
--font-secondary: Arial, Helvetica, sans-serif
--font-mono: 'Courier New', Courier, monospace
```

### Font Sizes
```css
--text-xs: 0.75rem    /* 12px */
--text-sm: 0.875rem   /* 14px */
--text-base: 1rem     /* 16px */
--text-lg: 1.125rem   /* 18px */
--text-xl: 1.25rem    /* 20px */
--text-2xl: 1.5rem    /* 24px */
--text-3xl: 1.875rem  /* 30px */
--text-4xl: 2.25rem   /* 36px */
--text-5xl: 3rem      /* 48px */
```

### Headings
```html
<h1>Heading 1</h1> <!-- 2.25rem / 36px -->
<h2>Heading 2</h2> <!-- 1.875rem / 30px -->
<h3>Heading 3</h3> <!-- 1.5rem / 24px -->
<h4>Heading 4</h4> <!-- 1.25rem / 20px -->
<h5>Heading 5</h5> <!-- 1.125rem / 18px -->
<h6>Heading 6</h6> <!-- 1rem / 16px -->
```

---

## 📏 Spacing System

```css
--spacing-1: 0.25rem   /* 4px */
--spacing-2: 0.5rem    /* 8px */
--spacing-3: 0.75rem   /* 12px */
--spacing-4: 1rem      /* 16px */
--spacing-5: 1.25rem   /* 20px */
--spacing-6: 1.5rem    /* 24px */
--spacing-8: 2rem      /* 32px */
--spacing-10: 2.5rem   /* 40px */
--spacing-12: 3rem     /* 48px */
--spacing-16: 4rem     /* 64px */
--spacing-20: 5rem     /* 80px */
```

---

## 🔘 Button Components

### Basic Buttons
```html
<button class="btn btn-primary">Primary Button</button>
<button class="btn btn-secondary">Secondary Button</button>
<button class="btn btn-success">Success Button</button>
<button class="btn btn-danger">Danger Button</button>
```

### Role-Specific Buttons
```html
<button class="btn btn-admin">Admin Button</button>
<button class="btn btn-employee">Employee Button</button>
<button class="btn btn-secretariat">Secretariat Button</button>
```

### Button Sizes
```html
<button class="btn btn-primary btn-sm">Small</button>
<button class="btn btn-primary">Default</button>
<button class="btn btn-primary btn-lg">Large</button>
<button class="btn btn-primary btn-block">Full Width</button>
```

### Button States
```html
<button class="btn btn-primary" disabled>Disabled</button>
```

---

## 🃏 Card Components

### Basic Card
```html
<div class="card">
  <div class="card-header">
    <h3 class="card-title">Card Title</h3>
  </div>
  <div class="card-body">
    <p>Card content goes here...</p>
  </div>
  <div class="card-footer">
    <button class="btn btn-primary">Action</button>
  </div>
</div>
```

---

## 📝 Form Components

### Form Group
```html
<div class="form-group">
  <label class="form-label" for="input1">Label</label>
  <input type="text" class="form-control" id="input1" placeholder="Enter text">
  <small class="form-text">Helper text</small>
</div>
```

### Input Types
```html
<!-- Text Input -->
<input type="text" class="form-control" placeholder="Text input">

<!-- Email Input -->
<input type="email" class="form-control" placeholder="Email">

<!-- Password Input -->
<input type="password" class="form-control" placeholder="Password">

<!-- Select Dropdown -->
<select class="form-control">
  <option>Option 1</option>
  <option>Option 2</option>
</select>

<!-- Textarea -->
<textarea class="form-control" rows="4" placeholder="Message"></textarea>
```

### Form Validation
```html
<div class="form-group">
  <label class="form-label">Email</label>
  <input type="email" class="form-control" required>
  <div class="form-error">Please enter a valid email</div>
</div>
```

---

## 📊 Table Components

### Basic Table
```html
<table class="table">
  <thead>
    <tr>
      <th>Header 1</th>
      <th>Header 2</th>
      <th>Header 3</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>Data 1</td>
      <td>Data 2</td>
      <td>Data 3</td>
    </tr>
  </tbody>
</table>
```

### Striped Table
```html
<table class="table table-striped">
  <!-- table content -->
</table>
```

---

## 🏷️ Badge Components

```html
<span class="badge badge-primary">Primary</span>
<span class="badge badge-success">Success</span>
<span class="badge badge-warning">Warning</span>
<span class="badge badge-danger">Danger</span>
<span class="badge badge-info">Info</span>
```

---

## 🚨 Alert Components

```html
<div class="alert alert-success">Success message!</div>
<div class="alert alert-error">Error message!</div>
<div class="alert alert-warning">Warning message!</div>
<div class="alert alert-info">Info message!</div>
```

---

## 🪟 Modal Components

```html
<div class="modal-overlay">
  <div class="modal">
    <div class="modal-header">
      <h3 class="modal-title">Modal Title</h3>
      <button class="modal-close">&times;</button>
    </div>
    <div class="modal-body">
      <p>Modal content goes here...</p>
    </div>
    <div class="modal-footer">
      <button class="btn btn-secondary">Cancel</button>
      <button class="btn btn-primary">Confirm</button>
    </div>
  </div>
</div>
```

---

## 📐 Layout System

### Container
```html
<div class="container">
  <!-- Max-width 1200px, centered -->
</div>

<div class="container-fluid">
  <!-- Full width -->
</div>
```

### Grid System
```html
<div class="row">
  <div class="col-6">Half width</div>
  <div class="col-6">Half width</div>
</div>

<div class="row">
  <div class="col-4">One third</div>
  <div class="col-4">One third</div>
  <div class="col-4">One third</div>
</div>
```

---

## 🧭 Navigation Components

### Navbar
```html
<nav class="navbar">
  <div class="container">
    <a href="#" class="navbar-brand">PSAU GAD</a>
    <ul class="navbar-nav">
      <li><a href="#" class="nav-link active">Home</a></li>
      <li><a href="#" class="nav-link">Activities</a></li>
      <li><a href="#" class="nav-link">Contact</a></li>
    </ul>
  </div>
</nav>
```

### Sidebar
```html
<aside class="sidebar">
  <ul class="sidebar-menu">
    <li class="sidebar-item">
      <a href="#" class="sidebar-link active">Dashboard</a>
    </li>
    <li class="sidebar-item">
      <a href="#" class="sidebar-link">Activities</a>
    </li>
  </ul>
</aside>
```

---

## 📈 Dashboard Stats Cards

```html
<div class="stat-card admin">
  <div class="stat-value">150</div>
  <div class="stat-label">Total Employees</div>
</div>

<div class="stat-card employee">
  <div class="stat-value">25</div>
  <div class="stat-label">Active Activities</div>
</div>

<div class="stat-card secretariat">
  <div class="stat-value">85%</div>
  <div class="stat-label">Participation Rate</div>
</div>
```

---

## 🎭 Utility Classes

### Text Alignment
```html
<div class="text-center">Centered text</div>
<div class="text-left">Left aligned</div>
<div class="text-right">Right aligned</div>
```

### Text Colors
```html
<p class="text-primary">Primary color</p>
<p class="text-success">Success color</p>
<p class="text-warning">Warning color</p>
<p class="text-error">Error color</p>
<p class="text-muted">Muted text</p>
```

### Background Colors
```html
<div class="bg-primary">Primary background</div>
<div class="bg-admin">Admin background</div>
<div class="bg-employee">Employee background</div>
<div class="bg-secretariat">Secretariat background</div>
```

### Spacing Utilities
```html
<!-- Margin Top -->
<div class="mt-1">Margin top 4px</div>
<div class="mt-4">Margin top 16px</div>

<!-- Margin Bottom -->
<div class="mb-1">Margin bottom 4px</div>
<div class="mb-4">Margin bottom 16px</div>

<!-- Padding -->
<div class="p-1">Padding 4px</div>
<div class="p-4">Padding 16px</div>
```

### Display Utilities
```html
<div class="d-none">Hidden</div>
<div class="d-block">Block</div>
<div class="d-flex">Flex</div>
<div class="d-grid">Grid</div>
```

### Flexbox Utilities
```html
<div class="d-flex flex-column">Column direction</div>
<div class="d-flex justify-center">Centered</div>
<div class="d-flex justify-between">Space between</div>
<div class="d-flex align-center">Align center</div>
<div class="d-flex gap-4">Gap 16px</div>
```

### Border Radius
```html
<div class="rounded">Rounded corners</div>
<div class="rounded-full">Fully rounded</div>
```

### Shadows
```html
<div class="shadow">Base shadow</div>
<div class="shadow-lg">Large shadow</div>
```

---

## 🎬 Animations

### Fade In
```html
<div class="fade-in">Fades in on load</div>
```

### Slide In
```html
<div class="slide-in">Slides in from top</div>
```

---

## 📱 Responsive Design

The system is mobile-responsive with breakpoints at:
- **Mobile:** < 768px
- **Tablet:** 768px - 1024px
- **Desktop:** > 1024px

On mobile devices:
- Sidebar becomes full-width
- Grid columns stack vertically
- Navigation becomes vertical
- Modals take 95% width

---

## 🖨️ Print Styles

When printing:
- Sidebar, navbar, and buttons are hidden
- Background colors removed
- Cards get simple borders
- Optimized for paper output

---

## 💡 Usage Examples

### Complete Login Form
```html
<div class="card">
  <div class="card-header">
    <h3 class="card-title">Login</h3>
  </div>
  <div class="card-body">
    <form>
      <div class="form-group">
        <label class="form-label">Email</label>
        <input type="email" class="form-control" placeholder="Enter email">
      </div>
      <div class="form-group">
        <label class="form-label">Password</label>
        <input type="password" class="form-control" placeholder="Enter password">
      </div>
      <button type="submit" class="btn btn-primary btn-block">Login</button>
    </form>
  </div>
</div>
```

---

## 📦 How to Use

### 1. Include the CSS file in your HTML:
```html
<link rel="stylesheet" href="assets/css/gad-system.css">
```

### 2. Use the classes in your HTML:
```html
<button class="btn btn-primary">Click Me</button>
```

### 3. Customize using CSS variables:
```css
:root {
  --color-primary: #your-color;
}
```

---

## ✅ Best Practices

1. **Use semantic HTML** - Use appropriate HTML tags
2. **Follow BEM naming** - For custom components
3. **Mobile-first** - Design for mobile, enhance for desktop
4. **Accessibility** - Use proper ARIA labels and roles
5. **Performance** - Minimize CSS, use CSS variables
6. **Consistency** - Stick to the design system

---

**Pampanga State Agricultural University**  
GAD Information System  
© 2025 - All Rights Reserved

**Version:** 2.0.0  
**Last Updated:** 2025-11-03

