# Admin Module - Quick Start Guide

## 🚀 Getting Started

### 1. Access the Admin Panel

**URL:** `http://localhost/GAD/admin/dashboard.php`

**Login Credentials:**
- You need an admin account to access the admin panel
- If you don't have one, create it via the database or use the setup script

### 2. Create Admin Account (via Database)

Run this SQL in phpMyAdmin:

```sql
-- Create admin user
INSERT INTO users (email, password_hash, role, is_approved, is_active, is_psau_account) 
VALUES ('admin@psau.edu.ph', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', 1, 1, 1);

-- Get the user_id (check the last inserted ID)
SET @admin_id = LAST_INSERT_ID();

-- Create admin profile
INSERT INTO employee_profiles (user_id, first_name, last_name, gender, category)
VALUES (@admin_id, 'Admin', 'User', 'Male', 'Faculty');
```

**Default Password:** `password` (change this immediately!)

---

## 📋 Admin Features Overview

### **Dashboard** (`/admin/dashboard.php`)
- View system statistics
- Quick access to key functions
- Charts and visualizations
- Recent activity feed

### **Activities** (`/admin/activities.php`)
- Create new activities
- Edit existing activities
- View registrations
- Delete activities

### **Employees** (`/admin/employees.php`)
- View all employees
- Filter by category/gender
- View employee profiles
- Track participation

### **Account Approvals** (`/admin/account-approvals.php`)
- Approve/reject new accounts
- Non-PSAU accounts require manual approval
- PSAU accounts (@psau.edu.ph) are auto-approved

### **Registration Approvals** (`/admin/registration-approvals.php`)
- Approve/reject activity registrations
- QR codes are generated upon approval
- Email notifications (when configured)

### **Attendance** (`/admin/attendance.php`)
- View attendance statistics
- Scan QR codes
- Walk-in registration
- Track present/late/absent

### **Reports** (`/admin/reports.php`)
- GAR Report
- Training/Seminar Report
- Sex Disaggregated Data
- Attendance Report
- Custom Reports

---

## 🎯 Common Workflows

### **Workflow 1: Create and Manage Activity**

1. Go to **Activities** → Click **Create Activity**
2. Fill in activity details:
   - Title, Description, Objectives
   - Date, Time, Venue
   - Target Participants, Budget
   - Prerequisites (optional)
3. Click **Create Activity**
4. Activity is now visible to employees

### **Workflow 2: Approve Registrations**

1. Go to **Registration Approvals**
2. Review pending registrations
3. Click **Approve** to:
   - Approve the registration
   - Generate QR code
   - Send email notification (if configured)
4. Or click **Reject** to deny registration

### **Workflow 3: Mark Attendance**

**Option A: QR Code Scanner**
1. Go to **GAD Attendance**
2. Find the activity
3. Click **Scan QR Code**
4. Allow camera permissions
5. Click **Start Scanner**
6. Point camera at employee's QR code
7. System automatically marks attendance

**Option B: Walk-in Registration**
1. Go to **GAD Attendance**
2. Find the activity
3. Click **Walk-in**
4. Search for employee
5. Mark as present/late

### **Workflow 4: Approve New Accounts**

1. Go to **Account Approvals**
2. Review pending accounts
3. Check employee information
4. Click **Approve** to activate account
5. Or click **Reject** to deny access

---

## 🔧 Configuration

### **Grace Period for Attendance**

Default: 20 minutes

To change, edit `/config/config.php`:

```php
define('ATTENDANCE_GRACE_PERIOD', 20); // minutes
```

**How it works:**
- Activity starts at 9:00 AM
- Grace period: 20 minutes
- Scan before 9:20 AM = **Present**
- Scan after 9:20 AM = **Late**

### **Email Notifications**

Email notifications are currently disabled. To enable:

1. Configure SMTP in `/includes/classes/Email.php`
2. Uncomment email sending code in:
   - `/admin/registration-approvals.php`
   - `/admin/account-approvals.php`

### **QR Code Settings**

QR codes are generated using QR Server API (free, no API key needed).

**Storage:** `/uploads/qr_codes/`

**Format:** PNG, 300x300 pixels

---

## 📊 Understanding Statistics

### **Dashboard Statistics**

- **Total Employees:** All registered employees
- **Pending Accounts:** Accounts awaiting approval
- **Pending Registrations:** Activity registrations awaiting approval
- **Total Activities:** All activities in the system

### **Attendance Statistics**

- **Registered:** Total approved registrations
- **Present:** Attended on time (within grace period)
- **Late:** Attended after grace period
- **Absent:** Registered but did not attend
- **Attendance Rate:** (Present + Late) / Registered × 100%

---

## 🎨 Color Coding

- **Blue:** Admin theme color
- **Green:** Success, Present
- **Yellow:** Warning, Pending, Late
- **Red:** Error, Rejected, Absent
- **Purple:** Special actions, QR codes

---

## 🔐 Security Notes

1. **Always use strong passwords** for admin accounts
2. **Change default password** immediately
3. **Don't share admin credentials**
4. **Review approvals carefully** before accepting
5. **Monitor system logs** in `/logs/`

---

## 🐛 Troubleshooting

### **Can't access admin panel**
- Check if you're logged in as admin
- Verify role in database: `SELECT role FROM users WHERE email = 'your@email.com'`
- Clear browser cache and cookies

### **QR scanner not working**
- Allow camera permissions in browser
- Use HTTPS (camera requires secure connection)
- Try different browser (Chrome recommended)

### **Charts not displaying**
- Check browser console for errors
- Ensure Chart.js is loading (check internet connection)
- Clear browser cache

### **Permission errors**
- Check file permissions: `chmod -R 755 /Applications/XAMPP/xamppfiles/htdocs/GAD`
- Check upload directories: `chmod -R 777 uploads logs`

---

## 📱 Mobile Access

All admin pages are mobile-responsive:
- Dashboard works on tablets
- QR scanner works on mobile phones
- Forms are touch-friendly
- Tables scroll horizontally on small screens

---

## 🔄 Next Steps

After setting up the admin module:

1. **Create sample activities** to test the system
2. **Invite employees** to register
3. **Test the approval workflow**
4. **Practice QR scanning** before actual events
5. **Generate test reports**

---

## 📞 Need Help?

- Check `TROUBLESHOOTING.md` for common issues
- Review `ADMIN_MODULE_SUMMARY.md` for detailed documentation
- Check error logs in `/logs/error.log`
- Use `health-check.php` for system diagnostics

---

## ✅ Checklist for First Use

- [ ] Admin account created
- [ ] Logged in successfully
- [ ] Dashboard loads correctly
- [ ] Created first activity
- [ ] Tested approval workflow
- [ ] QR scanner works
- [ ] Charts display correctly
- [ ] Mobile view tested

---

**Last Updated:** 2025-11-03  
**Version:** 1.0  
**Module:** Admin Panel

