<?php
require_once 'config/config.php';
$pageTitle = '404 - Page Not Found';
include 'includes/header.php';
?>

<div class="min-h-screen flex items-center justify-center bg-gradient-to-br from-purple-50 to-purple-100">
    <div class="text-center">
        <div class="mb-8">
            <i class="fas fa-exclamation-triangle text-9xl text-purple-500"></i>
        </div>
        <h1 class="text-6xl font-bold text-gray-900 mb-4">404</h1>
        <h2 class="text-2xl font-semibold text-gray-700 mb-4">Page Not Found</h2>
        <p class="text-gray-600 mb-8">The page you're looking for doesn't exist or has been moved.</p>
        <a href="<?php echo BASE_URL; ?>/index.php" 
           class="inline-block bg-primary text-white px-8 py-3 rounded-lg font-semibold hover:bg-primary-dark transition">
            <i class="fas fa-home mr-2"></i> Go Home
        </a>
    </div>
</div>

<?php include 'includes/footer.php'; ?>

